/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hiveio.output;

import com.facebook.hiveio.output.HiveApiOutputCommitter;
import com.facebook.hiveio.output.HiveApiOutputFormat;
import com.facebook.hiveio.output.HiveOutputDescription;
import com.facebook.hiveio.output.RecordWriterImpl;
import com.facebook.hiveio.record.HiveWritableRecord;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.HackJobContext;
import org.apache.hadoop.mapred.HackTaskAttemptContext;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.thrift.TException;

public class HiveOutput {
    private HiveOutput() {
    }

    public static void writeTable(HiveOutputDescription outputDesc, Iterable<HiveWritableRecord> records) throws TException, IOException, InterruptedException {
        long uniqueId = System.nanoTime();
        String taskAttemptIdStr = "attempt_200707121733_" + (int)uniqueId + "_m_000005_0";
        String profile = Long.toString(uniqueId);
        HiveConf conf = new HiveConf(HiveOutput.class);
        conf.setInt("mapred.task.partition", 1);
        conf.set("mapred.task.id", taskAttemptIdStr);
        HiveApiOutputFormat.initProfile((Configuration)conf, outputDesc, profile);
        HiveApiOutputFormat outputFormat = new HiveApiOutputFormat();
        outputFormat.setMyProfileId(profile);
        TaskAttemptID taskAttemptID = TaskAttemptID.forName((String)taskAttemptIdStr);
        HackTaskAttemptContext taskContext = new HackTaskAttemptContext(new JobConf((Configuration)conf), taskAttemptID);
        HackJobContext jobContext = new HackJobContext(new JobConf((Configuration)conf), (JobID)taskAttemptID.getJobID());
        RecordWriterImpl recordWriter = outputFormat.getRecordWriter((TaskAttemptContext)taskContext);
        HiveApiOutputCommitter committer = outputFormat.getOutputCommitter((TaskAttemptContext)taskContext);
        committer.setupJob((JobContext)jobContext);
        committer.setupTask((TaskAttemptContext)taskContext);
        for (HiveWritableRecord record : records) {
            recordWriter.write((WritableComparable)NullWritable.get(), record);
        }
        recordWriter.close((TaskAttemptContext)taskContext);
        committer.commitTask((TaskAttemptContext)taskContext);
        committer.commitJob((JobContext)jobContext);
    }
}

