/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hiveio.output;

import com.facebook.hiveio.common.BackoffRetryTask;
import com.facebook.hiveio.common.FileSystems;
import com.facebook.hiveio.common.HadoopUtils;
import com.facebook.hiveio.common.HiveUtils;
import com.facebook.hiveio.common.Inspectors;
import com.facebook.hiveio.common.ProgressReporter;
import com.facebook.hiveio.output.HiveApiOutputCommitter;
import com.facebook.hiveio.output.HiveOutputDescription;
import com.facebook.hiveio.output.OutputConf;
import com.facebook.hiveio.output.OutputInfo;
import com.facebook.hiveio.output.RecordWriterImpl;
import com.facebook.hiveio.output.ResettableRecordWriterImpl;
import com.facebook.hiveio.record.HiveWritableRecord;
import com.facebook.hiveio.schema.HiveTableSchema;
import com.facebook.hiveio.schema.HiveTableSchemaImpl;
import com.facebook.hiveio.schema.HiveTableSchemas;
import com.facebook.hiveio.table.HiveTables;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.ThriftHiveMetastore;
import org.apache.hadoop.hive.serde2.Serializer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.HackOutputCommitter;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCommitter;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveApiOutputFormat
extends org.apache.hadoop.mapreduce.OutputFormat<WritableComparable, HiveWritableRecord> {
    public static final String DEFAULT_PROFILE_ID = "output-profile";
    private static final Logger LOG = LoggerFactory.getLogger(HiveApiOutputFormat.class);
    private static final AtomicInteger CREATED_FILES_COUNTER = new AtomicInteger(0);
    private String myProfileId = "output-profile";

    public void initialize(HiveOutputDescription outputDescription, String profileId, Configuration conf) {
        Preconditions.checkNotNull((Object)outputDescription, (Object)"inputDescription is null");
        Preconditions.checkNotNull((Object)profileId, (Object)"profileId is null");
        Preconditions.checkNotNull((Object)conf, (Object)"conf is null");
        try {
            this.setMyProfileId(profileId);
            HiveApiOutputFormat.initProfile(conf, outputDescription, profileId);
            HiveTableSchemas.initTableSchema(conf, profileId, outputDescription.getTableDesc());
        }
        catch (IOException e) {
            throw new IllegalStateException("initialize: IOException occurred", e);
        }
    }

    public String getMyProfileId() {
        return this.myProfileId;
    }

    public void setMyProfileId(String myProfileId) {
        this.myProfileId = myProfileId;
    }

    public HiveTableSchema getTableSchema(Configuration conf) {
        return HiveTableSchemas.getFromConf(conf, this.myProfileId);
    }

    public void init(Configuration conf, HiveOutputDescription outputDesc) throws TException, IOException {
        HiveApiOutputFormat.initProfile(conf, outputDesc, this.myProfileId);
    }

    public static void initDefaultProfile(Configuration conf, HiveOutputDescription outputDesc) throws TException, IOException {
        HiveApiOutputFormat.initProfile(conf, outputDesc, DEFAULT_PROFILE_ID);
    }

    public static void initProfile(Configuration conf, HiveOutputDescription outputDesc, String profileId) throws IOException {
        String partitionPiece;
        Table table = HiveTables.getTable(conf, profileId, outputDesc);
        HiveApiOutputFormat.sanityCheck(table, outputDesc);
        OutputInfo outputInfo = new OutputInfo(table);
        if (outputInfo.hasPartitionInfo()) {
            try {
                partitionPiece = HiveUtils.computePartitionPath(outputInfo.getPartitionInfo(), outputDesc.getPartitionValues());
            }
            catch (MetaException e) {
                throw new IOException(e);
            }
        } else {
            partitionPiece = "_temp";
        }
        String partitionPath = outputInfo.getTableRoot() + "/" + partitionPiece;
        outputInfo.setPartitionPath(partitionPath);
        HadoopUtils.setOutputDir(conf, partitionPath);
        if (outputInfo.hasPartitionInfo()) {
            outputInfo.setFinalOutputPath(outputInfo.getPartitionPath());
        } else {
            outputInfo.setFinalOutputPath(table.getSd().getLocation());
        }
        HiveTableSchemaImpl tableSchema = HiveTableSchemaImpl.fromTable(conf, table);
        HiveTableSchemas.putToConf(conf, profileId, tableSchema);
        OutputConf outputConf = new OutputConf(conf, profileId);
        outputConf.writeOutputDescription(outputDesc);
        outputConf.writeOutputTableInfo(outputInfo);
        LOG.info("initProfile '{}' using {}", (Object)profileId, (Object)outputDesc);
    }

    private static void sanityCheck(Table table, HiveOutputDescription outputDesc) {
        StorageDescriptor sd = table.getSd();
        Preconditions.checkArgument((!sd.isCompressed() ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)HiveApiOutputFormat.nullOrEmpty(sd.getBucketCols()));
        Preconditions.checkArgument((boolean)HiveApiOutputFormat.nullOrEmpty(sd.getSortCols()));
        Preconditions.checkArgument((table.getPartitionKeysSize() == outputDesc.numPartitionValues() ? 1 : 0) != 0);
    }

    private static <X> boolean nullOrEmpty(Collection<X> c) {
        return c == null || c.isEmpty();
    }

    private List<String> listOfPartitionValues(Map<String, String> partitionValues, List<FieldSchema> fieldSchemas) {
        ArrayList values = Lists.newArrayList();
        for (FieldSchema fieldSchema : fieldSchemas) {
            String value = partitionValues.get(fieldSchema.getName().toLowerCase());
            values.add(value);
        }
        return values;
    }

    public void checkOutputSpecs(JobContext jobContext) throws IOException, InterruptedException {
        Configuration conf = jobContext.getConfiguration();
        OutputConf outputConf = new OutputConf(conf, this.myProfileId);
        HiveOutputDescription description = outputConf.readOutputDescription();
        OutputInfo oti = outputConf.readOutputTableInfo();
        LOG.info("Check output specs of " + description);
        if (description == null) {
            LOG.error("HiveOutputDescription is null in Configuration, nothing to check");
            return;
        }
        this.checkTableExists(conf, description);
        if (oti == null) {
            LOG.error("OutputInfo is null in Configuration, nothing to check");
            return;
        }
        this.checkPartitionInfo(conf, description, oti, outputConf);
    }

    private void checkTableExists(final Configuration conf, final HiveOutputDescription description) throws IOException {
        BackoffRetryTask<Boolean> backoffRetryTask = new BackoffRetryTask<Boolean>(conf){

            @Override
            public Boolean idempotentTask() throws TException {
                ThriftHiveMetastore.Iface client = description.metastoreClient(conf);
                try {
                    client.get_table(description.getTableDesc().getDatabaseName(), description.getTableDesc().getTableName());
                }
                catch (NoSuchObjectException e) {
                    return false;
                }
                return true;
            }
        };
        if (!((Boolean)backoffRetryTask.run()).booleanValue()) {
            throw new IOException("Table does not exist");
        }
    }

    private void checkPartitionInfo(Configuration conf, HiveOutputDescription description, OutputInfo oti, OutputConf outputConf) throws IOException {
        if (oti.hasPartitionInfo()) {
            if (!description.hasPartitionValues()) {
                throw new IOException("table is partitioned but user input isn't");
            }
            if (outputConf.shouldDropPartitionIfExists()) {
                this.dropPartitionIfExists(conf, description, oti);
            } else {
                this.checkPartitionDoesntExist(conf, description, oti);
            }
        } else {
            if (description.hasPartitionValues()) {
                throw new IOException("table is not partitioned but user input is");
            }
            this.checkTableIsEmpty(conf, description, oti);
        }
    }

    private void checkTableIsEmpty(Configuration conf, HiveOutputDescription description, OutputInfo oti) throws IOException {
        Path tablePath = new Path(oti.getTableRoot());
        FileSystem fs = tablePath.getFileSystem(conf);
        if (fs.exists(tablePath) && FileSystems.dirHasNonHiddenFiles(fs, tablePath)) {
            throw new IOException("Table " + description.getTableDesc().getTableName() + " has existing data");
        }
    }

    private void checkPartitionDoesntExist(final Configuration conf, final HiveOutputDescription description, final OutputInfo oti) throws IOException {
        BackoffRetryTask<Boolean> backoffRetryTask = new BackoffRetryTask<Boolean>(conf){

            @Override
            public Boolean idempotentTask() throws TException {
                Map<String, String> partitionSpec;
                List partitionValues;
                ThriftHiveMetastore.Iface client = description.metastoreClient(conf);
                String db = description.getTableDesc().getDatabaseName();
                String table = description.getTableDesc().getTableName();
                if (oti.hasPartitionInfo() && HiveApiOutputFormat.this.partitionExists(client, db, table, partitionValues = HiveApiOutputFormat.this.listOfPartitionValues(partitionSpec = description.getPartitionValues(), oti.getPartitionInfo()))) {
                    LOG.error("Table " + db + ":" + table + " partition " + partitionSpec + " already exists");
                    return true;
                }
                return false;
            }
        };
        if (((Boolean)backoffRetryTask.run()).booleanValue()) {
            throw new IOException("Table already exists");
        }
    }

    private boolean partitionExists(ThriftHiveMetastore.Iface client, String db, String table, List<String> partitionValues) {
        List partitionNames;
        try {
            partitionNames = client.get_partition_names_ps(db, table, partitionValues, (short)1);
        }
        catch (Exception e) {
            return false;
        }
        return !partitionNames.isEmpty();
    }

    private boolean dropPartitionIfExists(Configuration conf, HiveOutputDescription description, OutputInfo oti) throws IOException {
        Map<String, String> partitionSpec;
        List<String> partitionValues;
        ThriftHiveMetastore.Iface client;
        try {
            client = description.metastoreClient(conf);
        }
        catch (TException e) {
            throw new IOException(e);
        }
        String db = description.getTableDesc().getDatabaseName();
        String table = description.getTableDesc().getTableName();
        if (oti.hasPartitionInfo() && this.partitionExists(client, db, table, partitionValues = this.listOfPartitionValues(partitionSpec = description.getPartitionValues(), oti.getPartitionInfo()))) {
            LOG.info("Dropping partition {} from table {}:{}", new Object[]{partitionSpec, db, table});
            return this.dropPartition(client, db, table, partitionValues);
        }
        return false;
    }

    private boolean dropPartition(ThriftHiveMetastore.Iface client, String db, String table, List<String> partitionValues) {
        try {
            return client.drop_partition(db, table, partitionValues, true);
        }
        catch (Exception e) {
            return false;
        }
    }

    public RecordWriterImpl getRecordWriter(TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        HadoopUtils.setWorkOutputDir(taskAttemptContext);
        Configuration conf = taskAttemptContext.getConfiguration();
        OutputConf outputConf = new OutputConf(conf, this.myProfileId);
        OutputInfo oti = outputConf.readOutputTableInfo();
        HiveUtils.setRCileNumColumns(conf, oti.getColumnInfo().size());
        HadoopUtils.setOutputKeyWritableClass(conf, NullWritable.class);
        Serializer serializer = oti.createSerializer(conf);
        HadoopUtils.setOutputValueWritableClass(conf, serializer.getSerializedClass());
        OutputFormat baseOutputFormat = (OutputFormat)ReflectionUtils.newInstance(oti.getOutputFormatClass(), (Configuration)conf);
        RecordWriter<WritableComparable, Writable> baseWriter = HiveApiOutputFormat.getBaseRecordWriter(taskAttemptContext, baseOutputFormat);
        StructObjectInspector soi = Inspectors.createFor(oti.getColumnInfo());
        if (!outputConf.shouldResetSlowWrites()) {
            return new RecordWriterImpl(baseWriter, serializer, (ObjectInspector)soi);
        }
        long writeTimeout = outputConf.getWriteResetTimeout();
        return new ResettableRecordWriterImpl(baseWriter, serializer, (ObjectInspector)soi, taskAttemptContext, baseOutputFormat, writeTimeout);
    }

    protected static RecordWriter<WritableComparable, Writable> getBaseRecordWriter(TaskAttemptContext taskAttemptContext, OutputFormat baseOutputFormat) throws IOException {
        HadoopUtils.setWorkOutputDir(taskAttemptContext);
        JobConf jobConf = new JobConf(taskAttemptContext.getConfiguration());
        int fileId = CREATED_FILES_COUNTER.incrementAndGet();
        String name = FileOutputFormat.getUniqueName((JobConf)jobConf, (String)("part-" + fileId));
        ProgressReporter reporter = new ProgressReporter((Progressable)taskAttemptContext);
        RecordWriter baseWriter = baseOutputFormat.getRecordWriter(null, jobConf, name, (Progressable)reporter);
        LOG.info("getBaseRecordWriter: Created new {} with file {}", (Object)baseWriter, (Object)name);
        return baseWriter;
    }

    public HiveApiOutputCommitter getOutputCommitter(TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        HadoopUtils.setWorkOutputDir(taskAttemptContext);
        Configuration conf = taskAttemptContext.getConfiguration();
        JobConf jobConf = new JobConf(conf);
        OutputCommitter baseCommitter = jobConf.getOutputCommitter();
        LOG.info("Getting output committer with base output committer {}", (Object)baseCommitter.getClass().getSimpleName());
        return new HiveApiOutputCommitter(new HackOutputCommitter(baseCommitter, jobConf), this.myProfileId);
    }
}

