/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hiveio.output;

import com.facebook.hiveio.common.BackoffRetryTask;
import com.facebook.hiveio.common.FileSystems;
import com.facebook.hiveio.common.HadoopUtils;
import com.facebook.hiveio.common.HiveUtils;
import com.facebook.hiveio.output.HiveOutputDescription;
import com.facebook.hiveio.output.OutputConf;
import com.facebook.hiveio.output.OutputInfo;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.ThriftHiveMetastore;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HiveApiOutputCommitter
extends OutputCommitter {
    private static final Logger LOG = LoggerFactory.getLogger(HiveApiOutputCommitter.class);
    private final String profileId;
    private final OutputCommitter baseCommitter;

    public HiveApiOutputCommitter(OutputCommitter baseCommitter, String profileId) {
        this.baseCommitter = baseCommitter;
        this.profileId = profileId;
    }

    public void setupJob(JobContext jobContext) throws IOException {
        this.baseCommitter.setupJob(jobContext);
    }

    public void commitJob(JobContext jobContext) throws IOException {
        this.baseCommitter.commitJob(jobContext);
        Configuration conf = jobContext.getConfiguration();
        OutputConf outputConf = new OutputConf(conf, this.profileId);
        HiveOutputDescription outputDesc = outputConf.readOutputDescription();
        OutputInfo outputInfo = outputConf.readOutputTableInfo();
        if (outputInfo.hasPartitionInfo()) {
            this.registerPartitions(conf, outputDesc, outputInfo);
        } else {
            this.noPartitionsCopyData(conf, outputInfo);
        }
        HiveApiOutputCommitter.writeSuccessFile(conf);
    }

    private static void writeSuccessFile(Configuration conf) throws IOException {
        Path successPath;
        if (!HadoopUtils.needSuccessMarker(conf)) {
            return;
        }
        Path outputPath = HadoopUtils.getOutputPath(conf);
        FileSystem fs = outputPath.getFileSystem(conf);
        if (fs.exists(outputPath) && !fs.exists(successPath = new Path(outputPath, "_SUCCESS"))) {
            LOG.info("Writing success file to {}", (Object)successPath);
            fs.create(successPath).close();
        }
    }

    private void registerPartitions(final Configuration conf, final HiveOutputDescription outputDesc, final OutputInfo outputInfo) throws IOException {
        BackoffRetryTask<Void> backoffRetryTask = new BackoffRetryTask<Void>(conf){

            @Override
            public Void idempotentTask() throws TException {
                String dbName = outputDesc.getTableDesc().getDatabaseName();
                String tableName = outputDesc.getTableDesc().getTableName();
                ThriftHiveMetastore.Iface client = outputDesc.metastoreClient(conf);
                Table hiveTable = client.get_table(dbName, tableName);
                Partition partition = new Partition();
                partition.setDbName(dbName);
                partition.setTableName(tableName);
                partition.setParameters(outputInfo.getTableParams());
                List<String> partitionValues = HiveUtils.orderedPartitionValues(hiveTable.getPartitionKeys(), outputDesc.getPartitionValues());
                partition.setValues(partitionValues);
                StorageDescriptor sd = new StorageDescriptor(hiveTable.getSd());
                sd.setParameters(outputInfo.getSerializerParams());
                sd.setLocation(outputInfo.getFinalOutputPath());
                sd.setCols(outputInfo.getColumnInfo());
                partition.setSd(sd);
                LOG.info("Registering partition with values {} located at {}", outputInfo.getSerializerParams(), (Object)outputInfo.getFinalOutputPath());
                try {
                    client.add_partition(partition);
                }
                catch (AlreadyExistsException e) {
                    LOG.info("Partition already exists; Giraph must have just created it");
                }
                catch (InvalidObjectException e) {
                    throw new IllegalStateException(e);
                }
                return null;
            }
        };
        backoffRetryTask.run();
    }

    private void noPartitionsCopyData(Configuration conf, OutputInfo outputInfo) throws IOException {
        Preconditions.checkArgument((!outputInfo.hasPartitionInfo() ? 1 : 0) != 0);
        Path tablePath = new Path(outputInfo.getTableRoot());
        Path writePath = new Path(outputInfo.getPartitionPath());
        FileSystem tableFs = tablePath.getFileSystem(conf);
        FileSystem writePathFs = writePath.getFileSystem(conf);
        if (!tableFs.getUri().equals(writePathFs.getUri())) {
            LOG.error("Table's root path fs {} is not on same as its partition path fs {}", (Object)tableFs.getUri(), (Object)writePathFs.getUri());
            throw new IllegalStateException("Table's root path fs " + tableFs.getUri() + " is not on same as its partition path fs " + writePathFs.getUri());
        }
        LOG.info("No partitions, copying data from {} to {}", (Object)writePath, (Object)tablePath);
        FileSystems.move(tableFs, writePath, writePath, tablePath);
        tableFs.delete(writePath, true);
    }

    @Deprecated
    public void cleanupJob(JobContext jobContext) throws IOException {
        this.baseCommitter.cleanupJob(jobContext);
    }

    public void abortJob(JobContext jobContext, JobStatus.State state) throws IOException {
        this.baseCommitter.abortJob(jobContext, state);
        HadoopUtils.deleteOutputDir(jobContext.getConfiguration());
    }

    public void setupTask(TaskAttemptContext taskContext) throws IOException {
        this.baseCommitter.setupTask(taskContext);
    }

    public boolean needsTaskCommit(TaskAttemptContext taskContext) throws IOException {
        return this.baseCommitter.needsTaskCommit(taskContext);
    }

    public void commitTask(TaskAttemptContext taskContext) throws IOException {
        HadoopUtils.setWorkOutputDir(taskContext);
        this.baseCommitter.commitTask(taskContext);
    }

    public void abortTask(TaskAttemptContext taskContext) throws IOException {
        this.baseCommitter.abortTask(taskContext);
    }
}

