/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hiveio.metrics;

import com.facebook.hiveio.metrics.SigarLongGauge;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricsRegistry;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

public class ProcessMemoryMetrics {
    private ProcessMemoryMetrics() {
    }

    public static void registerMetrics() {
        ProcessMemoryMetrics.registerMetrics(Metrics.defaultRegistry());
    }

    public static void registerMetrics(MetricsRegistry metrics) {
        ProcessMemoryMetrics.registerMetrics(metrics, ProcessMemoryMetrics.class);
    }

    public static void registerMetrics(MetricsRegistry metrics, Class<?> owningClass) {
        final Sigar sigar = new Sigar();
        final long pid = sigar.getPid();
        metrics.newGauge(owningClass, "process-memory-virtual", (Gauge)new SigarLongGauge(){

            @Override
            public long computeValue() throws SigarException {
                return sigar.getProcMem(pid).getSize();
            }
        });
        metrics.newGauge(owningClass, "process-memory-resident", (Gauge)new SigarLongGauge(){

            @Override
            public long computeValue() throws SigarException {
                return sigar.getProcMem(pid).getResident();
            }
        });
        metrics.newGauge(owningClass, "process-memory-shared", (Gauge)new SigarLongGauge(){

            @Override
            public long computeValue() throws SigarException {
                return sigar.getProcMem(pid).getShare();
            }
        });
        metrics.newGauge(owningClass, "process-memory-page-faults", (Gauge)new SigarLongGauge(){

            @Override
            public long computeValue() throws SigarException {
                return sigar.getProcMem(pid).getPageFaults();
            }
        });
    }
}

