/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hiveio.metrics;

import com.facebook.hiveio.metrics.SigarDoubleGauge;
import com.facebook.hiveio.metrics.SigarLongGauge;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricsRegistry;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

public class ProcessCpuMetrics {
    private ProcessCpuMetrics() {
    }

    public static void registerMetrics() {
        ProcessCpuMetrics.registerMetrics(Metrics.defaultRegistry());
    }

    public static void registerMetrics(MetricsRegistry metrics) {
        ProcessCpuMetrics.registerMetrics(metrics, ProcessCpuMetrics.class);
    }

    public static void registerMetrics(MetricsRegistry metrics, Class<?> owningClass) {
        final Sigar sigar = new Sigar();
        final long pid = sigar.getPid();
        metrics.newGauge(owningClass, "process-cpu-user", (Gauge)new SigarLongGauge(){

            @Override
            public long computeValue() throws SigarException {
                return sigar.getProcCpu(pid).getUser();
            }
        });
        metrics.newGauge(owningClass, "process-cpu-system", (Gauge)new SigarLongGauge(){

            @Override
            public long computeValue() throws SigarException {
                return sigar.getProcCpu(pid).getSys();
            }
        });
        metrics.newGauge(owningClass, "process-cpu-system", (Gauge)new SigarLongGauge(){

            @Override
            public long computeValue() throws SigarException {
                return sigar.getProcCpu(pid).getStartTime();
            }
        });
        metrics.newGauge(owningClass, "process-cpu-total", (Gauge)new SigarLongGauge(){

            @Override
            public long computeValue() throws SigarException {
                return sigar.getProcCpu(pid).getTotal();
            }
        });
        metrics.newGauge(owningClass, "process-cpu-pct", (Gauge)new SigarDoubleGauge(){

            @Override
            public double computeValue() throws SigarException {
                return sigar.getProcCpu(pid).getPercent();
            }
        });
    }
}

