/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hiveio.metrics;

import com.facebook.hiveio.metrics.SigarLongGauge;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricsRegistry;
import java.util.List;
import org.hyperic.sigar.NetInterfaceStat;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

public class NetworkMetrics {
    private NetworkMetrics() {
    }

    public static void registerMetrics() throws SigarException {
        NetworkMetrics.registerMetrics(Metrics.defaultRegistry());
    }

    public static void registerMetrics(MetricsRegistry metrics) throws SigarException {
        NetworkMetrics.registerMetrics(metrics, NetworkMetrics.class);
    }

    public static void registerMetrics(List<String> interfaceNames) throws SigarException {
        if (interfaceNames.isEmpty()) {
            NetworkMetrics.registerMetrics(Metrics.defaultRegistry(), NetworkMetrics.class);
        } else {
            Sigar sigar = new Sigar();
            for (String interfaceName : interfaceNames) {
                NetworkMetrics.registerMetrics(Metrics.defaultRegistry(), NetworkMetrics.class, interfaceName, sigar);
            }
        }
    }

    public static void registerMetrics(MetricsRegistry metrics, Class<?> owningClass) throws SigarException {
        String[] interfaceNames;
        Sigar sigar = new Sigar();
        for (String interfaceName : interfaceNames = sigar.getNetInterfaceList()) {
            NetworkMetrics.registerMetrics(metrics, owningClass, interfaceName, sigar);
        }
    }

    public static void registerMetrics(MetricsRegistry metrics, Class<?> owningClass, final String interfaceName, final Sigar sigar) throws SigarException {
        NetInterfaceStat netInterfaceStat = sigar.getNetInterfaceStat(interfaceName);
        final long initialRxBytes = netInterfaceStat.getRxBytes();
        final long initialRxPackets = netInterfaceStat.getRxPackets();
        final long initialTxBytes = netInterfaceStat.getTxBytes();
        final long initialTxPackets = netInterfaceStat.getTxPackets();
        metrics.newGauge(owningClass, "network-" + interfaceName + "-receive-bytes", (Gauge)new SigarLongGauge(){

            @Override
            public long computeValue() throws SigarException {
                return sigar.getNetInterfaceStat(interfaceName).getRxBytes() - initialRxBytes;
            }
        });
        metrics.newGauge(owningClass, "network-" + interfaceName + "-receive-packets", (Gauge)new SigarLongGauge(){

            @Override
            public long computeValue() throws SigarException {
                return sigar.getNetInterfaceStat(interfaceName).getRxPackets() - initialRxPackets;
            }
        });
        metrics.newGauge(owningClass, "network-" + interfaceName + "-send-bytes", (Gauge)new SigarLongGauge(){

            @Override
            public long computeValue() throws SigarException {
                return sigar.getNetInterfaceStat(interfaceName).getTxBytes() - initialTxBytes;
            }
        });
        metrics.newGauge(owningClass, "network-" + interfaceName + "-send-packets", (Gauge)new SigarLongGauge(){

            @Override
            public long computeValue() throws SigarException {
                return sigar.getNetInterfaceStat(interfaceName).getTxPackets() - initialTxPackets;
            }
        });
    }
}

