/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hiveio.log;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.ObjectStore;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.log4j.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveLogHelpers {
    private static final Logger LOG = LoggerFactory.getLogger(HiveLogHelpers.class);

    private HiveLogHelpers() {
    }

    public static void setHiveLogLevel(Level level) {
        ArrayList logs = Lists.newArrayList();
        logs.add(HiveMetaStore.LOG);
        HiveLogHelpers.addPrivateStaticLog(logs, Driver.class);
        HiveLogHelpers.addPrivateStaticLog(logs, ParseDriver.class);
        HiveLogHelpers.addPrivateStaticLog(logs, ObjectStore.class);
        for (Log log : logs) {
            HiveLogHelpers.setHiveLoggerLevel(log, level);
        }
    }

    public static void setHiveLoggerLevel(Log log, Level level) {
        if (log instanceof Log4JLogger) {
            Log4JLogger log4JLogger = (Log4JLogger)log;
            log4JLogger.getLogger().setLevel(level);
        } else {
            LOG.error("Don't know how to handle logger {} of type {}", (Object)log, log.getClass());
        }
    }

    private static void addPrivateStaticLog(List<Log> logs, Class<?> klass) {
        try {
            Field logField = klass.getDeclaredField("LOG");
            logField.setAccessible(true);
            Log driverLog = (Log)logField.get(null);
            logs.add(driverLog);
        }
        catch (IllegalAccessException e) {
            LOG.error("Could not get LOG from Hive ql.Driver", (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            LOG.error("Could not get LOG from Hive ql.Driver", (Throwable)e);
        }
    }
}

