/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hiveio.log;

import java.lang.reflect.Field;
import org.apache.log4j.Level;
import org.datanucleus.util.Log4JLogger;
import org.datanucleus.util.NucleusLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataNucleusLogHelpers {
    private static final Logger LOG = LoggerFactory.getLogger(DataNucleusLogHelpers.class);

    private DataNucleusLogHelpers() {
    }

    public static void setDataNucleusLogLevel(Level level) {
        NucleusLogger[] nucleusLoggers;
        Field log4jLoggerField;
        try {
            log4jLoggerField = Log4JLogger.class.getDeclaredField("logger");
        }
        catch (NoSuchFieldException e) {
            LOG.error("Could not get field logger from {}", (Object)Log4JLogger.class.getCanonicalName());
            return;
        }
        log4jLoggerField.setAccessible(true);
        for (NucleusLogger nucleusLogger : nucleusLoggers = new NucleusLogger[]{NucleusLogger.DATASTORE, NucleusLogger.DATASTORE_PERSIST, NucleusLogger.DATASTORE_RETRIEVE, NucleusLogger.DATASTORE_SCHEMA, NucleusLogger.DATASTORE_NATIVE, NucleusLogger.METADATA, NucleusLogger.PERSISTENCE}) {
            DataNucleusLogHelpers.setDatanucleusLoggerLevel(nucleusLogger, log4jLoggerField, level);
        }
        LOG.info("Done setting nucleus logger levels");
    }

    public static void setDatanucleusLoggerLevel(NucleusLogger nucleusLogger, Field log4jLoggerField, Level level) {
        if (nucleusLogger instanceof Log4JLogger) {
            org.apache.log4j.Logger logger;
            try {
                logger = (org.apache.log4j.Logger)log4jLoggerField.get(nucleusLogger);
            }
            catch (IllegalAccessException e) {
                LOG.error("Could not access field logger from Log4jLogger");
                return;
            }
            logger.setLevel(level);
        } else {
            LOG.error("Don't know how to handle logger {} of type {}", (Object)nucleusLogger, nucleusLogger.getClass());
        }
    }
}

