/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hiveio.input.parser.hive;

import com.facebook.hiveio.common.HiveType;
import com.facebook.hiveio.input.parser.Records;
import com.facebook.hiveio.record.HiveReadableRecord;
import com.facebook.hiveio.record.HiveRecord;
import com.facebook.hiveio.record.HiveWritableRecord;
import com.facebook.hiveio.schema.HiveTableSchema;
import com.google.common.base.Objects;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRecord
implements HiveRecord {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRecord.class);
    private final HiveTableSchema schema;
    private final Object[] rowData;
    private final String[] partitionValues;

    private DefaultRecord(HiveTableSchema schema, int numColumns, String[] partitionValues) {
        this.schema = schema;
        this.rowData = new Object[numColumns];
        this.partitionValues = partitionValues;
    }

    public static HiveReadableRecord forReading(HiveTableSchema schema, String[] partitionValues) {
        return new DefaultRecord(schema, schema.numColumns(), partitionValues);
    }

    public static HiveWritableRecord forWriting(HiveTableSchema schema) {
        return new DefaultRecord(schema, schema.numColumns(), new String[0]);
    }

    @Override
    public Object get(int index) {
        if (index < this.rowData.length) {
            return this.rowData[index];
        }
        return this.partitionValues[index - this.rowData.length];
    }

    @Override
    public Object get(int index, HiveType hiveType) {
        return Records.get(this, index, hiveType);
    }

    @Override
    public boolean getBoolean(int index) {
        Records.verifyType(index, HiveType.BOOLEAN, this.schema);
        Boolean v = (Boolean)this.get(index);
        return v == null ? false : v;
    }

    @Override
    public byte getByte(int index) {
        Records.verifyType(index, HiveType.BYTE, this.schema);
        Byte v = (Byte)this.get(index);
        return v == null ? (byte)-128 : (byte)v;
    }

    @Override
    public short getShort(int index) {
        Records.verifyType(index, HiveType.SHORT, this.schema);
        Short v = (Short)this.get(index);
        return v == null ? (short)Short.MIN_VALUE : (short)v;
    }

    @Override
    public int getInt(int index) {
        Records.verifyType(index, HiveType.INT, this.schema);
        Integer v = (Integer)this.get(index);
        return v == null ? Integer.MIN_VALUE : v;
    }

    @Override
    public long getLong(int index) {
        Records.verifyType(index, HiveType.LONG, this.schema);
        Long v = (Long)this.get(index);
        return v == null ? Long.MIN_VALUE : v;
    }

    @Override
    public float getFloat(int index) {
        Records.verifyType(index, HiveType.FLOAT, this.schema);
        Float v = (Float)this.get(index);
        return v == null ? Float.MIN_VALUE : v.floatValue();
    }

    @Override
    public double getDouble(int index) {
        Records.verifyType(index, HiveType.DOUBLE, this.schema);
        Double v = (Double)this.get(index);
        return v == null ? Double.NaN : v;
    }

    @Override
    public String getString(int index) {
        Records.verifyType(index, HiveType.STRING, this.schema);
        return (String)this.get(index);
    }

    @Override
    public <K, V> Map<K, V> getMap(int index) {
        Records.verifyMapLike(index, this.schema);
        return (Map)this.get(index);
    }

    @Override
    public <T> List<T> getList(int index) {
        Records.verifyType(index, HiveType.LIST, this.schema);
        return (List)this.get(index);
    }

    @Override
    public boolean isNull(int index) {
        return this.get(index) == null;
    }

    @Override
    public List<Object> getAllColumns() {
        return Arrays.asList(this.rowData);
    }

    @Override
    public void set(int index, Object value) {
        this.rowData[index] = DefaultRecord.upgradeType(this.schema, index, value);
    }

    @Override
    public void set(int index, Object value, HiveType hiveType) {
        Records.verifyType(index, hiveType, this.schema);
        this.rowData[index] = DefaultRecord.upgradeType(this.schema, index, value);
    }

    private static Object upgradeType(HiveTableSchema schema, int index, Object value) {
        if (value == null) {
            return null;
        }
        HiveType type = schema.columnType(index);
        return type.checkAndUpgrade(value);
    }

    private void setImpl(int index, Object value, HiveType expectedType) {
        Records.verifyType(index, expectedType, this.schema);
        this.rowData[index] = value;
    }

    @Override
    public void setBoolean(int index, boolean value) {
        this.setImpl(index, value, HiveType.BOOLEAN);
    }

    @Override
    public void setByte(int index, byte value) {
        this.setImpl(index, value, HiveType.BYTE);
    }

    @Override
    public void setShort(int index, short value) {
        this.setImpl(index, value, HiveType.SHORT);
    }

    @Override
    public void setInt(int index, int value) {
        this.setImpl(index, value, HiveType.INT);
    }

    @Override
    public void setLong(int index, long value) {
        this.setImpl(index, value, HiveType.LONG);
    }

    @Override
    public void setFloat(int index, float value) {
        this.setImpl(index, Float.valueOf(value), HiveType.FLOAT);
    }

    @Override
    public void setDouble(int index, double value) {
        this.setImpl(index, value, HiveType.DOUBLE);
    }

    @Override
    public void setString(int index, String value) {
        this.setImpl(index, value, HiveType.STRING);
    }

    @Override
    public void setMap(int index, Map data) {
        Records.verifyMapLike(index, this.schema);
        this.rowData[index] = data;
    }

    @Override
    public void setList(int index, List data) {
        this.setImpl(index, data, HiveType.LIST);
    }

    @Override
    public int numColumns() {
        return this.rowData.length;
    }

    @Override
    public int numPartitionValues() {
        return this.partitionValues.length;
    }

    @Override
    public HiveType columnType(int index) {
        return this.schema.columnType(index);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("numColumns", this.numColumns()).add("rowData", (Object)this.rowDataToString()).add("partitionData", (Object)this.partitionValues).toString();
    }

    private String rowDataToString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (int i = 0; i < this.rowData.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            if (this.rowData[i] == null) {
                sb.append("(null)");
                continue;
            }
            sb.append(this.rowData[i].getClass().getSimpleName());
            sb.append(":");
            sb.append(this.rowData[i].toString());
        }
        sb.append(']');
        return sb.toString();
    }
}

