/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hiveio.input.parser.array;

import com.facebook.hiveio.input.parser.RecordParser;
import com.facebook.hiveio.input.parser.array.ArrayParserData;
import com.facebook.hiveio.input.parser.array.ArrayRecord;
import com.facebook.hiveio.record.HiveReadableRecord;
import com.google.common.base.Charsets;
import java.io.IOException;
import org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable;
import org.apache.hadoop.hive.serde2.columnar.BytesRefWritable;
import org.apache.hadoop.io.Writable;

public class BytesParser
implements RecordParser {
    private final int[] columnIndexes;
    private final ArrayRecord record;

    public BytesParser(String[] partitionValues, ArrayParserData parserData) {
        this.columnIndexes = parserData.columnIndexes;
        this.record = new ArrayRecord(parserData.schema.numColumns(), partitionValues, parserData.hiveTypes);
    }

    @Override
    public HiveReadableRecord createRecord() {
        return this.record;
    }

    public HiveReadableRecord parse(Writable value, HiveReadableRecord record) throws IOException {
        BytesRefArrayWritable braw = (BytesRefArrayWritable)value;
        ArrayRecord arrayRecord = (ArrayRecord)record;
        arrayRecord.reset();
        for (int i = 0; i < this.columnIndexes.length; ++i) {
            int column = this.columnIndexes[i];
            if (braw.size() <= column) {
                arrayRecord.setNull(column, true);
                continue;
            }
            BytesRefWritable fieldData = braw.unCheckedGet(column);
            byte[] bytes = fieldData.getData();
            int start = fieldData.getStart();
            int length = fieldData.getLength();
            if (length == "\\N".length() && bytes[start] == 92 && bytes[start + 1] == 78) {
                arrayRecord.setNull(column, true);
                continue;
            }
            this.parsePrimitiveColumn(column, bytes, start, length);
        }
        return arrayRecord;
    }

    private void parsePrimitiveColumn(int column, byte[] bytes, int start, int length) {
        switch (this.record.getHiveType(column)) {
            case BOOLEAN: {
                Boolean bool = BytesParser.parseBoolean(bytes, start, length);
                if (bool == null) {
                    this.record.setNull(column, true);
                    break;
                }
                this.record.setBoolean(column, bool);
                break;
            }
            case BYTE: {
                if (length == 0) {
                    this.record.setNull(column, true);
                    break;
                }
                this.record.setByte(column, bytes[start]);
                break;
            }
            case SHORT: {
                if (length == 0) {
                    this.record.setNull(column, true);
                    break;
                }
                this.record.setShort(column, BytesParser.parseShort(bytes, start, length));
                break;
            }
            case INT: {
                if (length == 0) {
                    this.record.setNull(column, true);
                    break;
                }
                this.record.setInt(column, BytesParser.parseInt(bytes, start, length));
                break;
            }
            case LONG: {
                if (length == 0) {
                    this.record.setNull(column, true);
                    break;
                }
                this.record.setLong(column, BytesParser.parseLong(bytes, start, length));
                break;
            }
            case FLOAT: {
                if (length == 0) {
                    this.record.setNull(column, true);
                    break;
                }
                this.record.setFloat(column, BytesParser.parseFloat(bytes, start, length));
                break;
            }
            case DOUBLE: {
                if (length == 0) {
                    this.record.setNull(column, true);
                    break;
                }
                this.record.setDouble(column, BytesParser.parseDouble(bytes, start, length));
                break;
            }
            case STRING: {
                this.record.setString(column, BytesParser.parseString(bytes, start, length));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected HiveType " + (Object)((Object)this.record.getHiveType(column)));
            }
        }
    }

    public static String parseString(byte[] bytes, int start, int length) {
        return new String(bytes, start, length, Charsets.UTF_8);
    }

    public static Boolean parseBoolean(byte[] bytes, int start, int length) {
        if (length == 4 && BytesParser.toUpperCase(bytes[start + 0]) == 84 && BytesParser.toUpperCase(bytes[start + 1]) == 82 && BytesParser.toUpperCase(bytes[start + 2]) == 85 && BytesParser.toUpperCase(bytes[start + 3]) == 69) {
            return true;
        }
        if (length == 5 && BytesParser.toUpperCase(bytes[start + 0]) == 70 && BytesParser.toUpperCase(bytes[start + 1]) == 65 && BytesParser.toUpperCase(bytes[start + 2]) == 76 && BytesParser.toUpperCase(bytes[start + 3]) == 83 && BytesParser.toUpperCase(bytes[start + 4]) == 69) {
            return false;
        }
        return null;
    }

    private static byte toUpperCase(byte b) {
        return BytesParser.isLowerCase(b) ? (byte)(b - 32) : b;
    }

    private static boolean isLowerCase(byte b) {
        return b >= 97 && b <= 122;
    }

    public static short parseShort(byte[] bytes, int start, int length) {
        return (short)BytesParser.parseLong(bytes, start, length);
    }

    public static int parseInt(byte[] bytes, int start, int length) {
        return (int)BytesParser.parseLong(bytes, start, length);
    }

    public static long parseLong(byte[] bytes, int start, int length) {
        int sign;
        int limit = start + length;
        int n = sign = bytes[start] == 45 ? -1 : 1;
        if (sign == -1 || bytes[start] == 43) {
            // empty if block
        }
        int n2 = ++start;
        ++start;
        long value = bytes[n2] - 48;
        while (start < limit) {
            value = value * 10L + (long)(bytes[start] - 48);
            ++start;
        }
        return value * (long)sign;
    }

    public static float parseFloat(byte[] bytes, int start, int length) {
        char[] chars = new char[length];
        for (int pos = 0; pos < length; ++pos) {
            chars[pos] = (char)bytes[start + pos];
        }
        String string = new String(chars);
        return Float.parseFloat(string);
    }

    public static double parseDouble(byte[] bytes, int start, int length) {
        char[] chars = new char[length];
        for (int pos = 0; pos < length; ++pos) {
            chars[pos] = (char)bytes[start + pos];
        }
        String string = new String(chars);
        return Double.parseDouble(string);
    }
}

