/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hiveio.input.parser.array;

import com.facebook.hiveio.common.HiveType;
import com.facebook.hiveio.input.parser.Records;
import com.facebook.hiveio.record.HiveRecord;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ArrayRecord
implements HiveRecord {
    private final int numColumns;
    private final HiveType[] hiveTypes;
    private final boolean[] booleans;
    private final byte[] bytes;
    private final short[] shorts;
    private final int[] ints;
    private final long[] longs;
    private final float[] floats;
    private final double[] doubles;
    private final String[] strings;
    private final Object[] objects;
    private final boolean[] nulls;

    public ArrayRecord(int numColumns, String[] partitionValues, HiveType[] hiveTypes) {
        this.numColumns = numColumns;
        this.hiveTypes = hiveTypes;
        int size = numColumns + partitionValues.length;
        this.booleans = new boolean[size];
        this.bytes = new byte[size];
        this.shorts = new short[size];
        this.ints = new int[size];
        this.longs = new long[size];
        this.floats = new float[size];
        this.doubles = new double[size];
        this.strings = new String[size];
        this.objects = new Object[size];
        this.nulls = new boolean[size];
        for (int partIndex = 0; partIndex < partitionValues.length; ++partIndex) {
            this.strings[partIndex + numColumns] = partitionValues[partIndex];
        }
    }

    @Override
    public int numColumns() {
        return this.numColumns;
    }

    @Override
    public int numPartitionValues() {
        return this.booleans.length - this.numColumns;
    }

    @Override
    public HiveType columnType(int index) {
        return this.hiveTypes[index];
    }

    public int getSize() {
        return this.booleans.length;
    }

    public void reset() {
        Arrays.fill(this.nulls, false);
    }

    public HiveType getHiveType(int index) {
        return this.hiveTypes[index];
    }

    @Override
    public void setBoolean(int index, boolean value) {
        this.booleans[index] = value;
    }

    @Override
    public void setLong(int index, long value) {
        this.longs[index] = value;
    }

    @Override
    public void setDouble(int index, double value) {
        this.doubles[index] = value;
    }

    @Override
    public void setString(int index, String value) {
        this.strings[index] = value;
    }

    @Override
    public void set(int index, Object value) {
        this.set(index, value, this.hiveTypes[index]);
    }

    @Override
    public void set(int index, Object value, HiveType hiveType) {
        Records.verifyType(index, hiveType, this.hiveTypes[index]);
    }

    @Override
    public void setByte(int index, byte value) {
        this.bytes[index] = value;
    }

    @Override
    public void setShort(int index, short value) {
        this.shorts[index] = value;
    }

    @Override
    public void setInt(int index, int value) {
        this.ints[index] = value;
    }

    @Override
    public void setFloat(int index, float value) {
        this.floats[index] = value;
    }

    @Override
    public void setMap(int index, Map data) {
        this.objects[index] = data;
    }

    @Override
    public void setList(int index, List data) {
        this.objects[index] = data;
    }

    public void setObject(int index, Object value) {
        this.objects[index] = value;
    }

    public void setNull(int index, boolean value) {
        this.nulls[index] = value;
    }

    @Override
    public List<Object> getAllColumns() {
        ArrayList result = Lists.newArrayListWithCapacity((int)this.numColumns);
        for (int i = 0; i < this.numColumns(); ++i) {
            result.add(this.get(i));
        }
        return result;
    }

    @Override
    public Object get(int index) {
        if (this.nulls[index]) {
            return null;
        }
        return this.get(index, this.hiveTypes[index]);
    }

    @Override
    public Object get(int index, HiveType hiveType) {
        return Records.get(this, index, hiveType);
    }

    @Override
    public boolean getBoolean(int index) {
        Records.verifyType(index, HiveType.BOOLEAN, this.hiveTypes[index]);
        return this.booleans[index];
    }

    @Override
    public byte getByte(int index) {
        Records.verifyType(index, HiveType.BYTE, this.hiveTypes[index]);
        return this.bytes[index];
    }

    @Override
    public short getShort(int index) {
        Records.verifyType(index, HiveType.SHORT, this.hiveTypes[index]);
        return this.shorts[index];
    }

    @Override
    public int getInt(int index) {
        Records.verifyType(index, HiveType.INT, this.hiveTypes[index]);
        return this.ints[index];
    }

    @Override
    public long getLong(int index) {
        Records.verifyType(index, HiveType.LONG, this.hiveTypes[index]);
        return this.longs[index];
    }

    @Override
    public float getFloat(int index) {
        Records.verifyType(index, HiveType.FLOAT, this.hiveTypes[index]);
        return this.floats[index];
    }

    @Override
    public double getDouble(int index) {
        Records.verifyType(index, HiveType.DOUBLE, this.hiveTypes[index]);
        return this.doubles[index];
    }

    @Override
    public String getString(int index) {
        Records.verifyType(index, HiveType.STRING, this.hiveTypes[index]);
        return this.strings[index];
    }

    @Override
    public <K, V> Map<K, V> getMap(int index) {
        Records.verifyMapLike(index, this.hiveTypes[index]);
        return (Map)this.objects[index];
    }

    @Override
    public <T> List<T> getList(int index) {
        Records.verifyType(index, HiveType.LIST, this.hiveTypes[index]);
        return (List)this.objects[index];
    }

    @Override
    public boolean isNull(int index) {
        return this.nulls[index];
    }

    public String toString() {
        Objects.ToStringHelper tsh = Objects.toStringHelper((Object)this);
        for (int i = 0; i < this.getSize(); ++i) {
            tsh.add("type[" + i + "]", (Object)this.hiveTypes[i]);
            tsh.add("data[" + i + "]", this.get(i));
        }
        return tsh.toString();
    }
}

