/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hiveio.input.parser.array;

import com.facebook.hiveio.common.HiveType;
import com.facebook.hiveio.schema.HiveTableSchema;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

public class ArrayParserData {
    public final Deserializer deserializer;
    public final StructObjectInspector inspector;
    public final int[] columnIndexes;
    public final PrimitiveObjectInspector[] primitiveInspectors;
    public final StructField[] structFields;
    public final HiveType[] hiveTypes;
    public final HiveTableSchema schema;

    public ArrayParserData(Deserializer deserializer, int[] columnIndexes, HiveTableSchema schema, String[] partitionValues) {
        this.schema = schema;
        this.deserializer = deserializer;
        this.columnIndexes = columnIndexes;
        int numColumns = schema.numColumns();
        this.primitiveInspectors = new PrimitiveObjectInspector[numColumns];
        this.structFields = new StructField[numColumns];
        this.hiveTypes = new HiveType[numColumns + partitionValues.length];
        for (int partIndex = 0; partIndex < partitionValues.length; ++partIndex) {
            this.hiveTypes[partIndex + numColumns] = HiveType.STRING;
        }
        try {
            this.inspector = (StructObjectInspector)deserializer.getObjectInspector();
        }
        catch (SerDeException e) {
            throw new IllegalStateException(e);
        }
    }
}

