/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hiveio.input.parser.array;

import com.facebook.hiveio.common.HiveType;
import com.facebook.hiveio.input.parser.RecordParser;
import com.facebook.hiveio.input.parser.array.ArrayParserData;
import com.facebook.hiveio.input.parser.array.ArrayRecord;
import com.facebook.hiveio.record.HiveReadableRecord;
import java.io.IOException;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.io.Writable;

public class ArrayParser
implements RecordParser {
    private final ArrayParserData parserData;
    private final ArrayRecord record;

    public ArrayParser(String[] partitionValues, ArrayParserData parserData) {
        this.parserData = parserData;
        this.record = new ArrayRecord(parserData.schema.numColumns(), partitionValues, parserData.hiveTypes);
    }

    @Override
    public HiveReadableRecord createRecord() {
        return this.record;
    }

    public HiveReadableRecord parse(Writable value, HiveReadableRecord record) throws IOException {
        Object rowData;
        ArrayRecord arrayRecord = (ArrayRecord)record;
        arrayRecord.reset();
        try {
            rowData = this.parserData.deserializer.deserialize(value);
        }
        catch (SerDeException e) {
            throw new IOException(e);
        }
        for (int i = 0; i < this.parserData.columnIndexes.length; ++i) {
            int columnIndex = this.parserData.columnIndexes[i];
            if (this.parserData.inspector.getAllStructFieldRefs().size() <= columnIndex) {
                arrayRecord.setNull(columnIndex, true);
                continue;
            }
            StructField structField = this.parserData.structFields[columnIndex];
            Object fieldData = this.parserData.inspector.getStructFieldData(rowData, structField);
            if (fieldData == null) {
                arrayRecord.setNull(columnIndex, true);
                continue;
            }
            if (arrayRecord.getHiveType(columnIndex).isCollection()) {
                ObjectInspector fieldInspector = structField.getFieldObjectInspector();
                Object parsed = ObjectInspectorUtils.copyToStandardJavaObject((Object)fieldData, (ObjectInspector)fieldInspector);
                arrayRecord.setObject(columnIndex, parsed);
                continue;
            }
            this.parsePrimitive(arrayRecord, columnIndex, fieldData);
        }
        return arrayRecord;
    }

    private void parsePrimitive(ArrayRecord arrayRecord, int columnIndex, Object fieldData) {
        PrimitiveObjectInspector fieldInspector = this.parserData.primitiveInspectors[columnIndex];
        Object primitiveData = fieldInspector.getPrimitiveJavaObject(fieldData);
        HiveType hiveType = arrayRecord.getHiveType(columnIndex);
        switch (hiveType) {
            case BOOLEAN: {
                arrayRecord.setBoolean(columnIndex, (Boolean)primitiveData);
                break;
            }
            case BYTE: {
                arrayRecord.setByte(columnIndex, (Byte)primitiveData);
                break;
            }
            case SHORT: {
                arrayRecord.setShort(columnIndex, (Short)primitiveData);
                break;
            }
            case INT: {
                arrayRecord.setInt(columnIndex, (Integer)primitiveData);
                break;
            }
            case LONG: {
                arrayRecord.setLong(columnIndex, (Long)primitiveData);
                break;
            }
            case FLOAT: {
                arrayRecord.setFloat(columnIndex, ((Float)primitiveData).floatValue());
                break;
            }
            case DOUBLE: {
                arrayRecord.setDouble(columnIndex, (Double)primitiveData);
                break;
            }
            case STRING: {
                arrayRecord.setString(columnIndex, (String)primitiveData);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected HiveType " + (Object)((Object)hiveType));
            }
        }
    }
}

