/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hiveio.input.parser;

import com.facebook.hiveio.common.HiveType;
import com.facebook.hiveio.record.HiveReadableRecord;
import com.facebook.hiveio.schema.HiveTableSchema;

public class Records {
    private Records() {
    }

    public static Object get(HiveReadableRecord record, int index, HiveType hiveType) {
        switch (hiveType) {
            case BOOLEAN: {
                return record.getBoolean(index);
            }
            case BYTE: {
                return record.getByte(index);
            }
            case SHORT: {
                return record.getShort(index);
            }
            case INT: {
                return record.getInt(index);
            }
            case LONG: {
                return record.getLong(index);
            }
            case FLOAT: {
                return Float.valueOf(record.getFloat(index));
            }
            case DOUBLE: {
                return record.getDouble(index);
            }
            case STRING: {
                return record.getString(index);
            }
            case MAP: 
            case STRUCT: {
                return record.getMap(index);
            }
            case LIST: {
                return record.getList(index);
            }
        }
        throw new IllegalArgumentException("Don't know how to handle HiveType " + (Object)((Object)hiveType));
    }

    public static void verifyType(int index, HiveType expectedType, HiveTableSchema schema) {
        Records.verifyType(index, expectedType, schema.columnType(index));
    }

    public static void verifyType(int index, HiveType expectedType, HiveType actualType) {
        if (actualType != expectedType) {
            throw new IllegalArgumentException("Expected column " + index + " to be " + (Object)((Object)expectedType) + ", but is actually " + (Object)((Object)actualType));
        }
    }

    public static void verifyMapLike(int index, HiveTableSchema schema) {
        Records.verifyMapLike(index, schema.columnType(index));
    }

    public static void verifyMapLike(int index, HiveType actualType) {
        if (!actualType.isMapLike()) {
            throw new IllegalArgumentException("Expected column " + index + " to be MAP or STRUCT, but is actually " + (Object)((Object)actualType));
        }
    }
}

