/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hiveio.input.parser;

import com.facebook.hiveio.common.HiveTableDesc;
import com.facebook.hiveio.common.HiveType;
import com.facebook.hiveio.conf.ClassConfOption;
import com.facebook.hiveio.input.parser.RecordParser;
import com.facebook.hiveio.input.parser.array.ArrayParser;
import com.facebook.hiveio.input.parser.array.ArrayParserData;
import com.facebook.hiveio.input.parser.array.BytesParser;
import com.facebook.hiveio.input.parser.hive.DefaultParser;
import com.facebook.hiveio.schema.HiveTableSchema;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Parsers {
    public static final ClassConfOption<RecordParser> FORCE_PARSER = ClassConfOption.create("hiveio.input.parser", null, RecordParser.class);
    public static final Set<Class<? extends RecordParser>> CLASSES = ImmutableSet.builder().add(BytesParser.class).add(ArrayParser.class).add(DefaultParser.class).build();
    private static final Logger LOG = LoggerFactory.getLogger(Parsers.class);
    private static final NullStructField NULL_STRUCT_FIELD = new NullStructField();

    private Parsers() {
    }

    public static RecordParser<Writable> bestParser(Deserializer deserializer, HiveTableSchema schema, int[] columnIndexes, String[] partitionValues, Writable exampleValue, Configuration conf) {
        ArrayParserData data = new ArrayParserData(deserializer, columnIndexes, schema, partitionValues);
        int numColumns = schema.numColumns();
        HiveTableDesc tableDesc = schema.getTableDesc();
        for (int i = 0; i < numColumns; ++i) {
            data.structFields[i] = i < data.inspector.getAllStructFieldRefs().size() ? (StructField)data.inspector.getAllStructFieldRefs().get(i) : NULL_STRUCT_FIELD;
            ObjectInspector fieldInspector = data.structFields[i].getFieldObjectInspector();
            data.hiveTypes[i] = HiveType.fromHiveObjectInspector(fieldInspector);
            if (!data.hiveTypes[i].isPrimitive()) continue;
            data.primitiveInspectors[i] = (PrimitiveObjectInspector)fieldInspector;
        }
        boolean hasCollections = false;
        for (int i = 0; i < columnIndexes.length; ++i) {
            int columnId = columnIndexes[i];
            if (!data.hiveTypes[columnId].isCollection()) continue;
            hasCollections = true;
            break;
        }
        RecordParser parser = null;
        parser = !hasCollections && exampleValue instanceof BytesRefArrayWritable ? new BytesParser(partitionValues, data) : new ArrayParser(partitionValues, data);
        Class<RecordParser> forcedParserClass = FORCE_PARSER.get(conf);
        if (forcedParserClass == null) {
            LOG.info("Using {} to parse hive records from table {}", (Object)parser.getClass().getSimpleName(), (Object)tableDesc.dotString());
        } else {
            LOG.info("Using {} chosen by user instead of {} to parse hive records from table {}", new Object[]{forcedParserClass.getSimpleName(), parser.getClass().getSimpleName(), tableDesc.dotString()});
            parser = Parsers.createForcedParser(deserializer, schema, partitionValues, data, forcedParserClass);
        }
        return parser;
    }

    private static RecordParser<Writable> createForcedParser(Deserializer deserializer, HiveTableSchema schema, String[] partitionValues, ArrayParserData data, Class<? extends RecordParser> forcedParserClass) {
        RecordParser forcedParser;
        if (BytesParser.class.equals(forcedParserClass)) {
            forcedParser = new BytesParser(partitionValues, data);
        } else if (ArrayParser.class.equals(forcedParserClass)) {
            forcedParser = new ArrayParser(partitionValues, data);
        } else if (DefaultParser.class.equals(forcedParserClass)) {
            forcedParser = new DefaultParser(deserializer, partitionValues, schema);
        } else {
            throw new IllegalArgumentException("Don't know how to create parser " + forcedParserClass.getCanonicalName());
        }
        return forcedParser;
    }

    private static class NullStructField
    implements StructField {
        private NullStructField() {
        }

        public String getFieldName() {
            return null;
        }

        public ObjectInspector getFieldObjectInspector() {
            return PrimitiveObjectInspectorFactory.javaStringObjectInspector;
        }

        public String getFieldComment() {
            return "";
        }
    }
}

