/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hiveio.input;

import com.facebook.hiveio.input.HiveApiInputObserver;
import com.facebook.hiveio.input.parser.RecordParser;
import com.facebook.hiveio.record.HiveReadableRecord;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class RecordReaderImpl
extends RecordReader<WritableComparable, HiveReadableRecord> {
    private final org.apache.hadoop.mapred.RecordReader<WritableComparable, Writable> baseRecordReader;
    private final WritableComparable key;
    private final Writable value;
    private final RecordParser<Writable> parser;
    private HiveReadableRecord record;
    private HiveApiInputObserver observer;

    public RecordReaderImpl(org.apache.hadoop.mapred.RecordReader<WritableComparable, Writable> baseRecordReader, RecordParser parser) {
        this.baseRecordReader = baseRecordReader;
        this.key = (WritableComparable)baseRecordReader.createKey();
        this.value = (Writable)baseRecordReader.createValue();
        this.observer = HiveApiInputObserver.Empty.get();
        this.parser = parser;
    }

    public HiveApiInputObserver getObserver() {
        return this.observer;
    }

    public void setObserver(HiveApiInputObserver observer) {
        if (observer != null) {
            this.observer = observer;
        }
    }

    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        this.record = this.parser.createRecord();
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        this.observer.beginReadRow();
        boolean result = this.baseRecordReader.next((Object)this.key, (Object)this.value);
        this.observer.endReadRow(this.key, this.value);
        if (!result) {
            this.observer.hiveReadRowFailed();
            return false;
        }
        this.observer.beginParse();
        this.record = this.parser.parse(this.value, this.record);
        this.observer.endParse(this.record);
        return true;
    }

    public WritableComparable getCurrentKey() throws IOException, InterruptedException {
        return this.key;
    }

    public HiveReadableRecord getCurrentValue() throws IOException, InterruptedException {
        return this.record;
    }

    public float getProgress() throws IOException, InterruptedException {
        return this.baseRecordReader.getProgress();
    }

    public void close() throws IOException {
        this.baseRecordReader.close();
    }
}

