/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hiveio.input;

import com.facebook.hiveio.common.SerDes;
import com.facebook.hiveio.common.Writables;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InputSplitData
implements Writable {
    private static final Logger LOG = LoggerFactory.getLogger(InputSplitData.class);
    private Class<? extends SerDe> deserializerClass;
    private final Map<String, String> deserializerParams;
    private final List<FieldSchema> columnInfo;
    private final List<String> partitionValues;

    public InputSplitData() {
        this.deserializerParams = Maps.newHashMap();
        this.columnInfo = Lists.newArrayList();
        this.partitionValues = Lists.newArrayList();
    }

    public InputSplitData(StorageDescriptor storageDescriptor, List<String> partitionValues) {
        this.columnInfo = storageDescriptor.getCols();
        SerDeInfo serDeInfo = storageDescriptor.getSerdeInfo();
        this.deserializerClass = SerDes.getSerDeClass(serDeInfo);
        this.deserializerParams = serDeInfo.getParameters();
        this.partitionValues = partitionValues;
    }

    public Deserializer createDeserializer() {
        return SerDes.createSerDe(this.deserializerClass);
    }

    public boolean hasDeserializerClass() {
        return this.deserializerClass != null;
    }

    public Class<? extends Deserializer> getDeserializerClass() {
        return this.deserializerClass;
    }

    public Map<String, String> getDeserializerParams() {
        return this.deserializerParams;
    }

    public List<FieldSchema> getColumnInfo() {
        return this.columnInfo;
    }

    public List<String> getPartitionValues() {
        return this.partitionValues;
    }

    public void write(DataOutput out) throws IOException {
        Writables.writeFieldSchemas(out, this.columnInfo);
        Writables.writeClassName(out, (Class)Preconditions.checkNotNull(this.deserializerClass));
        Writables.writeStrStrMap(out, this.deserializerParams);
        Writables.writeStringList(out, this.partitionValues);
    }

    public void readFields(DataInput in) throws IOException {
        Writables.readFieldSchemas(in, this.columnInfo);
        this.deserializerClass = Writables.readClass(in);
        Writables.readStrStrMap(in, this.deserializerParams);
        Writables.readStringList(in, this.partitionValues);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("columnInfo", this.columnInfo).add("deserializerClass", this.deserializerClass).add("deserializerParams", this.deserializerParams).add("partitionValues", this.partitionValues).toString();
    }
}

