/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hiveio.input;

import com.facebook.hiveio.common.Classes;
import com.facebook.hiveio.common.HadoopUtils;
import com.facebook.hiveio.common.Writables;
import com.facebook.hiveio.input.InputSplitData;
import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InputPartition
implements Writable {
    private static final Logger LOG = LoggerFactory.getLogger(InputPartition.class);
    private final InputSplitData inputSplitData;
    private Class<? extends InputFormat> inputFormatClass;
    private String location;

    public InputPartition() {
        this.inputSplitData = new InputSplitData();
    }

    public InputPartition(InputSplitData inputSplitData, Class<? extends InputFormat> inputFormatClass, String location) {
        this.inputSplitData = inputSplitData;
        this.inputFormatClass = inputFormatClass;
        this.location = location;
    }

    public static InputPartition newFromHiveTable(Table table) {
        return InputPartition.makePartition(table.getSd(), Collections.emptyList());
    }

    public static InputPartition newFromHivePartition(Partition partition) {
        return InputPartition.makePartition(partition.getSd(), partition.getValues());
    }

    private static InputPartition makePartition(StorageDescriptor storageDescriptor, List<String> partitionValues) {
        InputSplitData splitData = new InputSplitData(storageDescriptor, partitionValues);
        Class inputFormatClass = Classes.classForName(storageDescriptor.getInputFormat());
        String location = storageDescriptor.getLocation();
        return new InputPartition(splitData, inputFormatClass, location);
    }

    public InputFormat makeInputFormat(Configuration conf) {
        InputFormat inputFormat = (InputFormat)ReflectionUtils.newInstance(this.inputFormatClass, (Configuration)conf);
        HadoopUtils.configureInputFormat(inputFormat, conf);
        return inputFormat;
    }

    public InputSplitData getInputSplitData() {
        return this.inputSplitData;
    }

    public String getLocation() {
        return this.location;
    }

    public void write(DataOutput out) throws IOException {
        Writables.writeClassName(out, (Class)Preconditions.checkNotNull(this.inputFormatClass));
        WritableUtils.writeString((DataOutput)out, (String)((String)Preconditions.checkNotNull((Object)this.location)));
        this.inputSplitData.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        this.inputFormatClass = Writables.readClass(in);
        this.location = WritableUtils.readString((DataInput)in);
        this.inputSplitData.readFields(in);
    }
}

