/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hiveio.input;

import com.facebook.hiveio.common.HiveTableDesc;
import com.facebook.hiveio.common.MetastoreDesc;
import com.facebook.hiveio.common.Writables;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.api.ThriftHiveMetastore;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.thrift.TException;

public class HiveInputDescription
implements Writable {
    private MetastoreDesc metastoreDesc = new MetastoreDesc();
    private HiveTableDesc tableDesc = new HiveTableDesc();
    private List<String> columns = Lists.newArrayList();
    private String partitionFilter = "";
    private int numSplits;

    public List<String> getColumns() {
        return this.columns;
    }

    public HiveInputDescription addColumn(String column) {
        this.columns.add(column);
        return this;
    }

    public HiveInputDescription setColumns(List<String> columns) {
        this.columns = columns;
        return this;
    }

    public boolean hasColumns() {
        return this.columns != null && !this.columns.isEmpty();
    }

    public HiveTableDesc getTableDesc() {
        return this.tableDesc;
    }

    public void setTableDesc(HiveTableDesc hiveTableDesc) {
        this.tableDesc = hiveTableDesc;
    }

    public String getPartitionFilter() {
        return this.partitionFilter;
    }

    public HiveInputDescription setPartitionFilter(String partitionFilter) {
        this.partitionFilter = partitionFilter;
        return this;
    }

    public boolean hasPartitionFilter() {
        return this.partitionFilter != null && !this.partitionFilter.isEmpty();
    }

    public int getNumSplits() {
        return this.numSplits;
    }

    public HiveInputDescription setNumSplits(int numSplits) {
        this.numSplits = numSplits;
        return this;
    }

    public MetastoreDesc getMetastoreDesc() {
        return this.metastoreDesc;
    }

    public ThriftHiveMetastore.Iface metastoreClient(Configuration conf) throws TException {
        return this.metastoreDesc.makeClient(conf);
    }

    public void write(DataOutput out) throws IOException {
        this.metastoreDesc.write(out);
        this.tableDesc.write(out);
        Writables.writeStringList(out, this.columns);
        WritableUtils.writeString((DataOutput)out, (String)this.partitionFilter);
        out.writeInt(this.numSplits);
    }

    public void readFields(DataInput in) throws IOException {
        this.metastoreDesc.readFields(in);
        this.tableDesc.readFields(in);
        Writables.readStringList(in, this.columns);
        this.partitionFilter = WritableUtils.readString((DataInput)in);
        this.numSplits = in.readInt();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("metastoreDesc", (Object)this.metastoreDesc).add("tableDesc", (Object)this.tableDesc).add("columns", this.columns).add("partitionFilter", (Object)this.partitionFilter).add("numSplits", (Object)String.valueOf(this.numSplits)).toString();
    }
}

