/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hiveio.input;

import com.facebook.hiveio.bean.RowToBean;
import com.facebook.hiveio.bean.UnsafeRowToBean;
import com.facebook.hiveio.common.HiveUtils;
import com.facebook.hiveio.common.RecordReaderWrapper;
import com.facebook.hiveio.input.HiveApiInputFormat;
import com.facebook.hiveio.input.HiveInputDescription;
import com.facebook.hiveio.input.RecordReaderImpl;
import com.facebook.hiveio.record.HiveReadableRecord;
import com.facebook.hiveio.schema.HiveTableSchema;
import com.facebook.hiveio.schema.HiveTableSchemas;
import com.google.common.base.Function;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveInput {
    private static final Logger LOG = LoggerFactory.getLogger(HiveInput.class);

    private HiveInput() {
    }

    public static Iterable<HiveReadableRecord> readTable(HiveInputDescription inputDesc) throws IOException, InterruptedException {
        HiveConf conf = HiveUtils.newHiveConf(HiveInput.class);
        return HiveInput.readTable(inputDesc, (Configuration)conf);
    }

    public static Iterable<HiveReadableRecord> readTable(HiveInputDescription inputDesc, final Configuration conf) throws IOException, InterruptedException {
        String profileID = Long.toString(System.currentTimeMillis());
        HiveApiInputFormat.setProfileInputDesc(conf, inputDesc, profileID);
        final HiveApiInputFormat inputFormat = new HiveApiInputFormat();
        inputFormat.setMyProfileId(profileID);
        JobContext jobContext = new JobContext(conf, new JobID());
        final List<InputSplit> splits = inputFormat.getSplits(jobContext);
        return new Iterable<HiveReadableRecord>(){

            @Override
            public Iterator<HiveReadableRecord> iterator() {
                return new RecordIterator(inputFormat, conf, splits.iterator());
            }
        };
    }

    public static <X> RowToBean<X> rowToBean(HiveInputDescription inputDesc, Class<X> rowClass) {
        try {
            HiveConf conf = HiveUtils.newHiveConf(HiveInput.class);
            HiveTableSchema schema = HiveTableSchemas.lookup((Configuration)conf, inputDesc.getTableDesc());
            UnsafeRowToBean<X> rowToBean = new UnsafeRowToBean<X>(rowClass, schema);
            return rowToBean;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <X> Iterable<X> readTable(HiveInputDescription inputDesc, Class<X> rowClass) throws IllegalAccessException, InstantiationException, IOException, InterruptedException {
        final X row = rowClass.newInstance();
        final RowToBean<X> rowMapper = HiveInput.rowToBean(inputDesc, rowClass);
        Function function = new Function<HiveReadableRecord, X>(){

            @Nullable
            public X apply(@Nullable HiveReadableRecord input) {
                rowMapper.writeRow(input, row);
                return row;
            }
        };
        return Iterables.transform(HiveInput.readTable(inputDesc), (Function)function);
    }

    private static class RecordIterator
    extends AbstractIterator<HiveReadableRecord> {
        private final HiveApiInputFormat inputFormat;
        private final Iterator<InputSplit> splits;
        private final TaskAttemptContext taskContext;
        private RecordReaderWrapper<HiveReadableRecord> recordReader;

        public RecordIterator(HiveApiInputFormat inputFormat, Configuration conf, Iterator<InputSplit> splits) {
            this.inputFormat = inputFormat;
            this.splits = splits;
            this.taskContext = new TaskAttemptContext(conf, new TaskAttemptID());
        }

        protected HiveReadableRecord computeNext() {
            while (this.recordReader == null || !this.recordReader.hasNext()) {
                RecordReaderImpl reader = null;
                while (this.splits.hasNext() && reader == null) {
                    InputSplit split = this.splits.next();
                    try {
                        reader = this.inputFormat.createRecordReader(split, this.taskContext);
                        reader.initialize(split, this.taskContext);
                    }
                    catch (Exception e) {
                        LOG.info("Couldn't create reader from split {}", (Object)split, (Object)e);
                    }
                }
                if (reader == null) {
                    return (HiveReadableRecord)this.endOfData();
                }
                this.recordReader = new RecordReaderWrapper(reader);
            }
            return (HiveReadableRecord)this.recordReader.next();
        }
    }
}

