/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hiveio.input;

import com.facebook.hiveio.common.BackoffRetryTask;
import com.facebook.hiveio.common.HadoopUtils;
import com.facebook.hiveio.common.HiveTableDesc;
import com.facebook.hiveio.common.HiveUtils;
import com.facebook.hiveio.common.Writables;
import com.facebook.hiveio.input.HInputSplit;
import com.facebook.hiveio.input.HiveApiInputObserver;
import com.facebook.hiveio.input.HiveInputDescription;
import com.facebook.hiveio.input.InputPartition;
import com.facebook.hiveio.input.RecordReaderImpl;
import com.facebook.hiveio.input.parser.Parsers;
import com.facebook.hiveio.input.parser.RecordParser;
import com.facebook.hiveio.record.HiveReadableRecord;
import com.facebook.hiveio.schema.HiveTableSchema;
import com.facebook.hiveio.schema.HiveTableSchemaImpl;
import com.facebook.hiveio.schema.HiveTableSchemas;
import com.google.common.base.Preconditions;
import com.google.common.collect.DiscreteDomains;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.Ranges;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.ThriftHiveMetastore;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.Progressable;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveApiInputFormat
extends InputFormat<WritableComparable, HiveReadableRecord> {
    public static final String DEFAULT_PROFILE_ID = "input-profile";
    private static final Logger LOG = LoggerFactory.getLogger(HiveApiInputFormat.class);
    private String myProfileId = "input-profile";
    private HiveApiInputObserver observer;

    public void initialize(HiveInputDescription inputDescription, String profileId, Configuration conf) {
        Preconditions.checkNotNull((Object)inputDescription, (Object)"inputDescription is null");
        Preconditions.checkNotNull((Object)profileId, (Object)"profileId is null");
        Preconditions.checkNotNull((Object)conf, (Object)"conf is null");
        this.setMyProfileId(profileId);
        HiveApiInputFormat.setProfileInputDesc(conf, inputDescription, profileId);
        try {
            HiveTableSchemas.initTableSchema(conf, profileId, inputDescription.getTableDesc());
        }
        catch (IOException e) {
            throw new IllegalStateException("initialize: IOException occurred", e);
        }
    }

    public String getMyProfileId() {
        return this.myProfileId;
    }

    public void setMyProfileId(String myProfileId) {
        this.myProfileId = myProfileId;
    }

    public HiveApiInputObserver getObserver() {
        return this.observer;
    }

    public void setObserver(HiveApiInputObserver observer) {
        this.observer = observer;
    }

    public HiveTableSchema getTableSchema(Configuration conf) {
        return HiveTableSchemas.getFromConf(conf, this.myProfileId);
    }

    private static String profileConfKey(String profileId) {
        return "hive.input." + profileId;
    }

    public static void setProfileInputDesc(Configuration conf, HiveInputDescription inputDesc, String profileId) {
        conf.set(HiveApiInputFormat.profileConfKey(profileId), Writables.writeToEncodedStr(inputDesc));
    }

    private HiveInputDescription readProfileInputDesc(Configuration conf) {
        HiveInputDescription inputDesc = new HiveInputDescription();
        Writables.readFieldsFromEncodedStr(conf.get(HiveApiInputFormat.profileConfKey(this.myProfileId)), inputDesc);
        return inputDesc;
    }

    public List<org.apache.hadoop.mapreduce.InputSplit> getSplits(JobContext jobContext) throws IOException, InterruptedException {
        final Configuration conf = jobContext.getConfiguration();
        final HiveInputDescription inputDesc = this.readProfileInputDesc(conf);
        BackoffRetryTask<SchemaAndPartitions> backoffRetryTask = new BackoffRetryTask<SchemaAndPartitions>(conf){

            @Override
            public SchemaAndPartitions idempotentTask() throws TException {
                ThriftHiveMetastore.Iface client = inputDesc.metastoreClient(conf);
                LOG.info("getSplits of " + inputDesc);
                HiveTableDesc tableDesc = inputDesc.getTableDesc();
                Table table = client.get_table(tableDesc.getDatabaseName(), tableDesc.getTableName());
                SchemaAndPartitions result = new SchemaAndPartitions();
                result.tableSchema = HiveTableSchemaImpl.fromTable(conf, table);
                HiveTableSchemas.putToConf(conf, HiveApiInputFormat.this.myProfileId, result.tableSchema);
                result.partitions = HiveApiInputFormat.this.computePartitions(inputDesc, client, table);
                return result;
            }
        };
        SchemaAndPartitions result = (SchemaAndPartitions)backoffRetryTask.run();
        List<org.apache.hadoop.mapreduce.InputSplit> splits = this.computeSplits(conf, inputDesc, result.tableSchema, result.partitions);
        return splits;
    }

    private List<org.apache.hadoop.mapreduce.InputSplit> computeSplits(Configuration conf, HiveInputDescription inputDesc, HiveTableSchema tableSchema, List<InputPartition> partitions) throws IOException {
        int partitionNum = 0;
        ArrayList splits = Lists.newArrayList();
        int[] columnIds = this.computeColumnIds(inputDesc.getColumns(), tableSchema);
        for (InputPartition inputPartition : partitions) {
            org.apache.hadoop.mapred.InputFormat baseInputFormat = inputPartition.makeInputFormat(conf);
            HadoopUtils.setInputDir(conf, inputPartition.getLocation());
            InputSplit[] baseSplits = baseInputFormat.getSplits(new JobConf(conf), inputDesc.getNumSplits());
            LOG.info("Requested {} splits from partition ({} out of {}) partition values: {}, got {} splits from inputFormat {}", new Object[]{inputDesc.getNumSplits(), partitionNum + 1, Iterables.size(partitions), inputPartition.getInputSplitData().getPartitionValues(), baseSplits.length, baseInputFormat.getClass().getCanonicalName()});
            for (InputSplit baseSplit : baseSplits) {
                HInputSplit split = new HInputSplit(baseInputFormat, baseSplit, tableSchema, columnIds, inputPartition.getInputSplitData(), conf);
                splits.add(split);
            }
            ++partitionNum;
        }
        return splits;
    }

    private int[] computeColumnIds(List<String> columnNames, HiveTableSchema tableSchema) {
        List ints;
        if (columnNames.isEmpty()) {
            Range range = Ranges.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(tableSchema.numColumns()));
            ints = range.asSet(DiscreteDomains.integers()).asList();
        } else {
            ints = Lists.transform(columnNames, HiveTableSchemas.schemaLookupFunc(tableSchema));
        }
        int[] result = new int[ints.size()];
        for (int i = 0; i < ints.size(); ++i) {
            result[i] = (Integer)ints.get(i);
        }
        return result;
    }

    private List<InputPartition> computePartitions(HiveInputDescription inputDesc, ThriftHiveMetastore.Iface client, Table table) throws TException {
        ArrayList partitions = Lists.newArrayList();
        if (table.getPartitionKeysSize() == 0) {
            partitions.add(InputPartition.newFromHiveTable(table));
        } else {
            HiveTableDesc tableDesc = inputDesc.getTableDesc();
            List hivePartitions = client.get_partitions_by_filter(tableDesc.getDatabaseName(), tableDesc.getTableName(), inputDesc.getPartitionFilter(), (short)-1);
            for (Partition hivePartition : hivePartitions) {
                partitions.add(InputPartition.newFromHivePartition(hivePartition));
            }
        }
        return partitions;
    }

    public RecordReaderImpl createRecordReader(org.apache.hadoop.mapreduce.InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        JobConf jobConf = new JobConf(conf);
        HInputSplit split = (HInputSplit)inputSplit;
        split.setConf((Configuration)jobConf);
        int[] columnIds = split.getColumnIds();
        HiveUtils.setReadColumnIds((Configuration)jobConf, columnIds);
        RecordReader<WritableComparable, Writable> baseRecordReader = split.getBaseRecordReader(jobConf, (Progressable)context);
        RecordParser<Writable> recordParser = this.getParser((Writable)baseRecordReader.createValue(), split, columnIds, conf);
        RecordReaderImpl reader = new RecordReaderImpl(baseRecordReader, recordParser);
        reader.setObserver(this.observer);
        return reader;
    }

    private RecordParser<Writable> getParser(Writable exampleValue, HInputSplit split, int[] columnIds, Configuration conf) {
        Deserializer deserializer = split.getDeserializer();
        String[] partitionValues = split.getPartitionValues();
        HiveTableSchema schema = split.getTableSchema();
        return Parsers.bestParser(deserializer, schema, columnIds, partitionValues, exampleValue, conf);
    }

    private static class SchemaAndPartitions {
        private HiveTableSchema tableSchema;
        private List<InputPartition> partitions;

        private SchemaAndPartitions() {
        }
    }
}

