/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hiveio.input;

import com.facebook.hiveio.common.HadoopUtils;
import com.facebook.hiveio.common.ProgressReporter;
import com.facebook.hiveio.common.SerDes;
import com.facebook.hiveio.common.Writables;
import com.facebook.hiveio.input.InputSplitData;
import com.facebook.hiveio.schema.HiveTableSchema;
import com.facebook.hiveio.schema.HiveTableSchemaImpl;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HInputSplit
extends InputSplit
implements org.apache.hadoop.mapred.InputSplit,
Configurable {
    private static final Logger LOG = LoggerFactory.getLogger(HInputSplit.class);
    private InputFormat baseInputFormat;
    private org.apache.hadoop.mapred.InputSplit baseSplit;
    private final HiveTableSchema tableSchema;
    private final InputSplitData inputSplitData;
    private int[] columnIds;
    private Configuration conf;
    private Deserializer deserializer;

    public HInputSplit() {
        this.tableSchema = new HiveTableSchemaImpl();
        this.inputSplitData = new InputSplitData();
        this.columnIds = new int[0];
    }

    public HInputSplit(InputFormat baseInputFormat, org.apache.hadoop.mapred.InputSplit baseSplit, HiveTableSchema tableSchema, int[] columnIds, InputSplitData inputSplitData, Configuration conf) {
        this.baseSplit = baseSplit;
        this.baseInputFormat = baseInputFormat;
        this.tableSchema = tableSchema;
        this.columnIds = columnIds;
        this.inputSplitData = inputSplitData;
        this.setConf(conf);
    }

    public Deserializer getDeserializer() {
        return (Deserializer)Preconditions.checkNotNull((Object)this.deserializer);
    }

    public String[] getPartitionValues() {
        List<String> partValues = this.inputSplitData.getPartitionValues();
        return partValues.toArray(new String[partValues.size()]);
    }

    public HiveTableSchema getTableSchema() {
        return this.tableSchema;
    }

    public int[] getColumnIds() {
        return this.columnIds;
    }

    public RecordReader<WritableComparable, Writable> getBaseRecordReader(JobConf jobConf, Progressable progressable) throws IOException {
        ProgressReporter reporter = new ProgressReporter(progressable);
        return this.baseInputFormat.getRecordReader(this.baseSplit, jobConf, (Reporter)reporter);
    }

    private void initDeserializer() {
        if (this.deserializer == null && this.inputSplitData.hasDeserializerClass()) {
            this.deserializer = this.inputSplitData.createDeserializer();
        }
        if (this.deserializer != null && this.conf != null) {
            SerDes.initDeserializer(this.deserializer, this.conf, this.inputSplitData.getColumnInfo(), this.inputSplitData.getDeserializerParams());
        }
    }

    public long getLength() throws IOException {
        return this.baseSplit.getLength();
    }

    public String[] getLocations() throws IOException {
        return this.baseSplit.getLocations();
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        HadoopUtils.setConfIfPossible(this.baseInputFormat, conf);
        HadoopUtils.setConfIfPossible(this.baseSplit, conf);
        HadoopUtils.setConfIfPossible(this.deserializer, conf);
        this.initDeserializer();
    }

    public Configuration getConf() {
        if (this.conf == null) {
            this.getConfFromMembers();
        }
        return this.conf;
    }

    private void getConfFromMembers() {
        Object[] objectsToCheck = new Object[]{this.baseSplit, this.baseInputFormat, this.deserializer};
        for (int i = 0; this.conf == null && i < objectsToCheck.length; ++i) {
            this.conf = HadoopUtils.getConfIfPossible(objectsToCheck[i]);
        }
    }

    public void write(DataOutput out) throws IOException {
        Writables.writeUnknownWritable(out, (Writable)this.baseSplit);
        Writables.writeClassName(out, this.baseInputFormat);
        this.tableSchema.write(out);
        this.inputSplitData.write(out);
        Writables.writeIntArray(out, this.columnIds);
    }

    public void readFields(DataInput in) throws IOException {
        this.baseSplit = (org.apache.hadoop.mapred.InputSplit)Writables.readUnknownWritable(in);
        this.baseInputFormat = (InputFormat)Writables.readNewInstance(in);
        HadoopUtils.configureInputFormat(this.baseInputFormat, this.conf);
        this.tableSchema.readFields(in);
        this.inputSplitData.readFields(in);
        this.columnIds = Writables.readIntArray(in);
        this.initDeserializer();
    }

    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("baseInputFormat class", this.baseInputFormat.getClass()).add("tableSchema", (Object)this.tableSchema).add("inputSplitData", (Object)this.inputSplitData).add("columnIds", (Object)Arrays.toString(this.columnIds)).add("baseSplitClass", this.baseSplit.getClass()).add("baseSplit", (Object)this.baseSplit).toString();
    }
}

