/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hiveio.conf;

import com.facebook.hiveio.conf.AbstractConfOption;
import com.facebook.hiveio.conf.AllOptions;
import com.facebook.hiveio.conf.ConfOptionType;
import org.apache.hadoop.conf.Configuration;

public class LongConfOption
extends AbstractConfOption {
    private long defaultValue;

    public LongConfOption(String key, long defaultValue) {
        super(key);
        this.defaultValue = defaultValue;
        AllOptions.add(this);
    }

    public long getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getDefaultValueStr() {
        return Long.toString(this.defaultValue);
    }

    @Override
    public ConfOptionType getType() {
        return ConfOptionType.LONG;
    }

    public long get(Configuration conf) {
        return conf.getLong(this.getKey(), this.defaultValue);
    }

    public void set(Configuration conf, long value) {
        conf.setLong(this.getKey(), value);
    }

    public void setIfUnset(Configuration conf, long value) {
        if (conf.get(this.getKey()) == null) {
            conf.setLong(this.getKey(), value);
        }
    }
}

