/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hiveio.conf;

import com.facebook.hiveio.conf.AbstractConfOption;
import com.facebook.hiveio.conf.AllOptions;
import com.facebook.hiveio.conf.ConfOptionType;
import org.apache.hadoop.conf.Configuration;

public class IntConfOption
extends AbstractConfOption {
    private final int defaultValue;

    public IntConfOption(String key, int defaultValue) {
        super(key);
        this.defaultValue = defaultValue;
        AllOptions.add(this);
    }

    public IntConfOption(String key, long defaultValue) {
        super(key);
        this.defaultValue = (int)defaultValue;
        AllOptions.add(this);
    }

    public int getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getDefaultValueStr() {
        return Integer.toString(this.defaultValue);
    }

    @Override
    public ConfOptionType getType() {
        return ConfOptionType.INTEGER;
    }

    public int get(Configuration conf) {
        return conf.getInt(this.getKey(), this.defaultValue);
    }

    public void set(Configuration conf, int value) {
        conf.setInt(this.getKey(), value);
    }

    public void setIfUnset(Configuration conf, int value) {
        if (conf.get(this.getKey()) == null) {
            conf.setInt(this.getKey(), value);
        }
    }
}

