/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hiveio.conf;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.HiveDriverRunHook;
import org.apache.hadoop.hive.ql.HiveDriverRunHookContext;
import org.apache.hadoop.hive.ql.HiveDriverRunHookContextImpl;
import org.apache.hadoop.hive.ql.hooks.Hook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveHooks {
    private static final Logger LOG = LoggerFactory.getLogger(HiveHooks.class);

    private HiveHooks() {
    }

    public static <T extends Hook> List<T> getHooks(HiveConf conf, HiveConf.ConfVars hookConfVar, Class<T> clazz) throws Exception {
        String[] hookClasses;
        ArrayList<Hook> hooks = new ArrayList<Hook>();
        String csHooks = conf.getVar(hookConfVar);
        if (csHooks == null) {
            return hooks;
        }
        if ((csHooks = csHooks.trim()).equals("")) {
            return hooks;
        }
        for (String hookClass : hookClasses = csHooks.split(",")) {
            try {
                Hook hook = (Hook)Class.forName(hookClass.trim(), true, JavaUtils.getClassLoader()).newInstance();
                hooks.add(hook);
            }
            catch (ClassNotFoundException e) {
                LOG.error("getHooks: " + hookConfVar.varname + " Class not found:" + e.getMessage());
                throw e;
            }
        }
        return hooks;
    }

    public static void runDriverPreHooks(HiveConf hiveConf) {
        try {
            HiveHooks.runDriverPreHooksThrows(hiveConf);
        }
        catch (Exception e) {
            LOG.error("runPreHooks: Failed to get hooks", (Throwable)e);
        }
    }

    public static void runDriverPreHooksThrows(HiveConf hiveConf) throws Exception {
        List<HiveDriverRunHook> hooks = HiveHooks.getHooks(hiveConf, HiveConf.ConfVars.HIVE_DRIVER_RUN_HOOKS, HiveDriverRunHook.class);
        HiveDriverRunHookContextImpl context = new HiveDriverRunHookContextImpl((Configuration)hiveConf, "no_cmd");
        for (HiveDriverRunHook hook : hooks) {
            LOG.info("runPreHooksThrows: Running hook " + hook + " of class " + hook.getClass());
            hook.preDriverRun((HiveDriverRunHookContext)context);
        }
    }
}

