/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hiveio.conf;

import com.facebook.hiveio.conf.AbstractConfOption;
import com.facebook.hiveio.conf.AllOptions;
import com.facebook.hiveio.conf.ConfOptionType;
import org.apache.hadoop.conf.Configuration;

public class FloatConfOption
extends AbstractConfOption {
    private final float defaultValue;

    public FloatConfOption(String key, float defaultValue) {
        super(key);
        this.defaultValue = defaultValue;
        AllOptions.add(this);
    }

    public float getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getDefaultValueStr() {
        return Float.toString(this.defaultValue);
    }

    @Override
    public ConfOptionType getType() {
        return ConfOptionType.FLOAT;
    }

    public float get(Configuration conf) {
        return conf.getFloat(this.getKey(), this.defaultValue);
    }

    public void set(Configuration conf, float value) {
        conf.setFloat(this.getKey(), value);
    }

    public void setIfUnset(Configuration conf, float value) {
        if (conf.get(this.getKey()) == null) {
            conf.setFloat(this.getKey(), value);
        }
    }
}

