/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hiveio.conf;

import com.facebook.hiveio.conf.AbstractConfOption;
import com.facebook.hiveio.conf.AllOptions;
import com.facebook.hiveio.conf.ConfOptionType;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassConfOption<C>
extends AbstractConfOption {
    private static final Logger LOG = LoggerFactory.getLogger(ClassConfOption.class);
    private final Class<C> interfaceClass;
    private final Class<? extends C> defaultClass;

    private ClassConfOption(String key, Class<? extends C> defaultClass, Class<C> interfaceClass) {
        super(key);
        this.defaultClass = defaultClass;
        this.interfaceClass = interfaceClass;
        AllOptions.add(this);
    }

    public static <T> ClassConfOption<T> create(String key, Class<? extends T> defaultClass, Class<T> interfaceClass) {
        return new ClassConfOption<T>(key, defaultClass, interfaceClass);
    }

    public Class<? extends C> getDefaultClass() {
        return this.defaultClass;
    }

    public Class<C> getInterfaceClass() {
        return this.interfaceClass;
    }

    @Override
    public String getDefaultValueStr() {
        return this.defaultClass == null ? "null" : this.defaultClass.getSimpleName();
    }

    @Override
    public ConfOptionType getType() {
        return ConfOptionType.CLASS;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(30);
        sb.append("  ");
        sb.append(this.getKey()).append(" => ").append(this.getDefaultValueStr());
        sb.append(" [").append(this.interfaceClass.getSimpleName()).append("] ");
        sb.append(" (").append(this.getType().toString().toLowerCase()).append(")\n");
        return sb.toString();
    }

    public Class<? extends C> get(Configuration conf) {
        return conf.getClass(this.getKey(), this.defaultClass, this.interfaceClass);
    }

    public Class<? extends C>[] getArray(Configuration conf) {
        return ClassConfOption.getClassesOfType(conf, this.getKey(), this.interfaceClass, new Class[0]);
    }

    public static <T> Class<? extends T>[] getClassesOfType(Configuration conf, String name, Class<T> xface, Class<? extends T> ... defaultValue) {
        Class[] klasses;
        for (Class klass : klasses = conf.getClasses(name, (Class[])defaultValue)) {
            if (xface.isAssignableFrom(klass)) continue;
            throw new RuntimeException(klass + " is not assignable from " + xface.getName());
        }
        return klasses;
    }

    public Class<? extends C> getWithDefault(Configuration conf, Class<? extends C> defaultValue) {
        return conf.getClass(this.getKey(), defaultValue, this.interfaceClass);
    }

    public void set(Configuration conf, Class<? extends C> klass) {
        conf.setClass(this.getKey(), klass, this.interfaceClass);
    }

    public void add(Configuration conf, Class<? extends C> klass) {
        ClassConfOption.addToClasses(conf, this.getKey(), klass, this.interfaceClass);
    }

    public static <T> void addToClasses(Configuration conf, String name, Class<? extends T> klass, Class<T> xface) {
        if (!xface.isAssignableFrom(klass)) {
            throw new RuntimeException(klass + " does not implement " + xface.getName());
        }
        String klasses = conf.get(name);
        String value = klasses == null ? klass.getName() : klasses + "," + klass.getName();
        conf.set(name, value);
    }
}

