/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hiveio.conf;

import com.facebook.hiveio.conf.AbstractConfOption;
import com.facebook.hiveio.conf.AllOptions;
import com.facebook.hiveio.conf.ConfOptionType;
import org.apache.hadoop.conf.Configuration;

public class BooleanConfOption
extends AbstractConfOption {
    private final boolean defaultValue;

    public BooleanConfOption(String key, boolean defaultValue) {
        super(key);
        this.defaultValue = defaultValue;
        AllOptions.add(this);
    }

    public boolean isDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getDefaultValueStr() {
        return Boolean.toString(this.defaultValue);
    }

    @Override
    public ConfOptionType getType() {
        return ConfOptionType.BOOLEAN;
    }

    public boolean get(Configuration conf) {
        return conf.getBoolean(this.getKey(), this.defaultValue);
    }

    public boolean isFalse(Configuration conf) {
        return !this.get(conf);
    }

    public boolean isTrue(Configuration conf) {
        return this.get(conf);
    }

    public void set(Configuration conf, boolean value) {
        conf.setBoolean(this.getKey(), value);
    }

    public void setIfUnset(Configuration conf, boolean value) {
        conf.setBooleanIfUnset(this.getKey(), value);
    }
}

