/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hiveio.conf;

import com.facebook.hiveio.conf.AbstractConfOption;
import com.facebook.hiveio.conf.ConfOptionType;
import com.facebook.hiveio.output.OutputConf;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllOptions {
    private static final Logger LOG = LoggerFactory.getLogger(AllOptions.class);
    private static final List<AbstractConfOption> CONF_OPTIONS = Lists.newArrayList();

    private AllOptions() {
    }

    public static void add(AbstractConfOption confOption) {
        CONF_OPTIONS.add(confOption);
    }

    public static String allOptionsString() {
        Collections.sort(CONF_OPTIONS);
        StringBuilder sb = new StringBuilder(CONF_OPTIONS.size() * 30);
        sb.append("All Options:\n");
        ConfOptionType lastType = null;
        for (AbstractConfOption confOption : CONF_OPTIONS) {
            if (!confOption.getType().equals((Object)lastType)) {
                sb.append(confOption.getType().toString().toLowerCase()).append(":\n");
                lastType = confOption.getType();
            }
            sb.append(confOption);
        }
        return sb.toString();
    }

    public static void main(String[] args) throws ClassNotFoundException {
        OutputConf.class.getCanonicalName();
        LOG.info(AllOptions.allOptionsString());
    }
}

