/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hiveio.common;

import com.facebook.hiveio.common.Classes;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerDes {
    private static final Logger LOG = LoggerFactory.getLogger(SerDes.class);

    protected SerDes() {
    }

    public static Properties getSerDeProperties(List<FieldSchema> fieldSchemas, Map<String, String> serDeParams) {
        Properties props = new Properties();
        props.setProperty("columns", MetaStoreUtils.getColumnNamesFromFieldSchema(fieldSchemas));
        props.setProperty("columns.types", MetaStoreUtils.getColumnTypesFromFieldSchema(fieldSchemas));
        props.setProperty("serialization.null.format", "\\N");
        props.setProperty("serialization.format", "1");
        props.putAll(serDeParams);
        return props;
    }

    public static Deserializer initDeserializer(Deserializer deserializer, Configuration conf, List<FieldSchema> fieldSchemas, Map<String, String> params) {
        Properties props = SerDes.getSerDeProperties(fieldSchemas, params);
        try {
            deserializer.initialize(conf, props);
        }
        catch (SerDeException e) {
            throw new IllegalStateException("Initializing Deserializer " + deserializer, e);
        }
        return deserializer;
    }

    public static Serializer initSerializer(Serializer serializer, Configuration conf, List<FieldSchema> fieldSchemas, Map<String, String> params) {
        Properties props = SerDes.getSerDeProperties(fieldSchemas, params);
        try {
            serializer.initialize(conf, props);
        }
        catch (SerDeException e) {
            throw new IllegalStateException("Initializing Serializer " + serializer, e);
        }
        return serializer;
    }

    public static SerDe initSerDe(SerDe serDe, Configuration conf, List<FieldSchema> fieldSchemas, Map<String, String> params) {
        Properties props = SerDes.getSerDeProperties(fieldSchemas, params);
        try {
            serDe.initialize(conf, props);
        }
        catch (SerDeException e) {
            throw new IllegalStateException("Initializing Serializer " + serDe, e);
        }
        return serDe;
    }

    public static Class<? extends SerDe> getSerDeClass(SerDeInfo serDeInfo) {
        return Classes.classForName(serDeInfo.getSerializationLib());
    }

    public static SerDe createSerDe(Class<? extends SerDe> serDeClass) {
        SerDe serDe = null;
        try {
            Constructor<? extends SerDe> constructor = serDeClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            serDe = constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            LOG.error("Could not instantiate SerDe {}", serDeClass, (Object)e);
        }
        return serDe;
    }

    public static SerDe createSerDe(SerDeInfo serDeInfo) {
        return SerDes.createSerDe(SerDes.getSerDeClass(serDeInfo));
    }
}

