/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hiveio.common;

import com.facebook.hiveio.common.HadoopNative;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public class NativeCodeHelper {
    protected NativeCodeHelper() {
    }

    protected static void loadLibrary(String name) throws IOException {
        URL url = Resources.getResource(HadoopNative.class, (String)NativeCodeHelper.getLibraryPath(name));
        File file = File.createTempFile(name, null);
        file.deleteOnExit();
        Files.copy((InputSupplier)Resources.newInputStreamSupplier((URL)url), (File)file);
        System.load(file.getAbsolutePath());
    }

    protected static String getLibraryPath(String name) {
        return "/nativelib/" + NativeCodeHelper.getPlatform() + "/" + System.mapLibraryName(name);
    }

    protected static String getPlatform() {
        String name = System.getProperty("os.name");
        String arch = System.getProperty("os.arch");
        return (name + "-" + arch).replace(' ', '_');
    }
}

