/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hiveio.common;

import com.facebook.hiveio.common.HiveMetastores;
import com.facebook.hiveio.common.HiveUtils;
import com.facebook.hiveio.output.HiveOutputDescription;
import com.google.common.base.CharMatcher;
import com.google.common.base.Objects;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.ThriftHiveMetastore;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.thrift.TException;

public class MetastoreDesc
implements Writable {
    private String host;
    private int port = 9083;

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public ThriftHiveMetastore.Iface makeClient(Configuration conf) throws TException {
        ThriftHiveMetastore.Iface client;
        if (this.hasHost()) {
            client = HiveMetastores.create(this.host, this.port, HiveMetastores.METASTORE_TIMEOUT_MS.get(conf));
        } else {
            HiveConf hiveConf = HiveUtils.newHiveConf(conf, HiveOutputDescription.class);
            client = HiveMetastores.create(hiveConf);
        }
        return client;
    }

    public boolean hasHost() {
        return this.host != null && !CharMatcher.WHITESPACE.matchesAllOf((CharSequence)this.host);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MetastoreDesc) {
            MetastoreDesc other = (MetastoreDesc)obj;
            return Objects.equal((Object)this.host, (Object)other.host) && this.port == other.port;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.host, this.port});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("host", (Object)this.host).add("port", this.port).toString();
    }

    public void readFields(DataInput in) throws IOException {
        this.host = WritableUtils.readString((DataInput)in);
        this.port = in.readInt();
    }

    public void write(DataOutput out) throws IOException {
        WritableUtils.writeString((DataOutput)out, (String)this.host);
        out.writeInt(this.port);
    }
}

