/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hiveio.common;

import com.facebook.hiveio.common.HiveStats;
import com.facebook.hiveio.common.HiveTableDesc;
import com.facebook.hiveio.common.HiveType;
import com.facebook.hiveio.common.SerDes;
import com.facebook.hiveio.input.HiveInputDescription;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.ThriftHiveMetastore;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveUtils {
    public static final Function<FieldSchema, String> FIELD_SCHEMA_NAME_GETTER = new Function<FieldSchema, String>(){

        public String apply(FieldSchema input) {
            return input == null ? null : input.getName();
        }
    };
    private static final Logger LOG = LoggerFactory.getLogger(HiveUtils.class);

    protected HiveUtils() {
    }

    public static HiveConf newHiveConf() {
        return HiveUtils.alterHiveConf(new HiveConf());
    }

    public static HiveConf newHiveConf(Class<?> klass) {
        return HiveUtils.alterHiveConf(new HiveConf(klass));
    }

    public static HiveConf newHiveConf(Configuration conf, Class<?> klass) {
        return HiveUtils.alterHiveConf(new HiveConf(conf, klass));
    }

    public static HiveConf alterHiveConf(HiveConf hiveConf) {
        return hiveConf;
    }

    public static HiveStats statsOf(ThriftHiveMetastore.Iface client, HiveInputDescription inputDesc) throws TException {
        HiveTableDesc tableDesc = inputDesc.getTableDesc();
        List partitions = client.get_partitions_by_filter(tableDesc.getDatabaseName(), tableDesc.getTableName(), inputDesc.getPartitionFilter(), (short)-1);
        HiveStats hiveStats = new HiveStats();
        for (int i = 0; i < partitions.size(); ++i) {
            Partition partition = (Partition)partitions.get(i);
            HiveStats partitionStats = HiveStats.fromParams(partition.getParameters());
            LOG.info("Adding HiveStats for partition {}: {}", (Object)partition.getValues(), (Object)partitionStats);
            hiveStats.add(partitionStats);
        }
        return hiveStats;
    }

    public static List<URI> getURIs(HiveConf conf, HiveConf.ConfVars key) {
        String[] parts = conf.getVar(key).split(",");
        ArrayList uris = Lists.newArrayList();
        for (int i = 0; i < parts.length; ++i) {
            URI uri;
            try {
                uri = new URI(parts[i]);
            }
            catch (URISyntaxException e) {
                LOG.error("URI syntax error", (Throwable)e);
                continue;
            }
            if (uri.getScheme() == null) {
                LOG.error("URI '{}' from key {} does not have a scheme", (Object)parts[i], (Object)key);
                continue;
            }
            uris.add(uri);
        }
        return uris;
    }

    public static HiveType[] columnTypes(Configuration conf, StorageDescriptor storageDescriptor) {
        SerDeInfo serDeInfo = storageDescriptor.getSerdeInfo();
        SerDe serDe = SerDes.createSerDe(serDeInfo);
        SerDes.initSerDe(serDe, conf, storageDescriptor.getCols(), serDeInfo.getParameters());
        StructObjectInspector inspector = null;
        try {
            inspector = (StructObjectInspector)serDe.getObjectInspector();
        }
        catch (SerDeException e) {
            LOG.error("Failed to get object inspector from table at {}", (Object)storageDescriptor.getLocation());
            throw new IllegalArgumentException("Failed to get object inspector from table at " + storageDescriptor.getLocation(), e);
        }
        List fields = inspector.getAllStructFieldRefs();
        HiveType[] types = new HiveType[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            types[i] = HiveType.fromHiveObjectInspector(((StructField)fields.get(i)).getFieldObjectInspector());
        }
        return types;
    }

    public static List<String> orderedPartitionValues(List<FieldSchema> partitionKeys, Map<String, String> partitionValuesMap) {
        List partitionNames = Lists.transform(partitionKeys, FIELD_SCHEMA_NAME_GETTER);
        return Lists.transform((List)partitionNames, (Function)Functions.forMap(partitionValuesMap));
    }

    public static String computePartitionPath(List<FieldSchema> partitionKeys, Map<String, String> partitionValuesMap) throws MetaException {
        List<String> values = HiveUtils.orderedPartitionValues(partitionKeys, partitionValuesMap);
        return Warehouse.makePartName(partitionKeys, values);
    }

    public static void setReadColumnIds(Configuration conf, List<Integer> columnIds) {
        if (columnIds.isEmpty()) {
            ColumnProjectionUtils.setFullyReadColumns((Configuration)conf);
        } else {
            ColumnProjectionUtils.setReadColumnIDs((Configuration)conf, columnIds);
        }
    }

    public static void setReadColumnIds(Configuration conf, int[] columnIds) {
        HiveUtils.setReadColumnIds(conf, Ints.asList((int[])columnIds));
    }

    public static void setRCileNumColumns(Configuration conf, int numColumns) {
        conf.set("hive.io.rcfile.column.number.conf", Integer.toOctalString(numColumns));
    }
}

