/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hiveio.common;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public enum HiveType {
    BOOLEAN{

        @Override
        public Object checkAndUpgrade(Object data) {
            Preconditions.checkArgument((boolean)(data instanceof Boolean));
            return data;
        }

        @Override
        public Class<?> javaClass() {
            return Boolean.class;
        }

        @Override
        public boolean isCollection() {
            return false;
        }

        @Override
        public boolean isIntegerType() {
            return false;
        }
    }
    ,
    BYTE{

        @Override
        public Object checkAndUpgrade(Object data) {
            Preconditions.checkArgument((boolean)(data instanceof Byte));
            return data;
        }

        @Override
        public Class<?> javaClass() {
            return Byte.class;
        }

        @Override
        public boolean isCollection() {
            return false;
        }

        @Override
        public boolean isIntegerType() {
            return true;
        }
    }
    ,
    SHORT{

        @Override
        public Object checkAndUpgrade(Object data) {
            Preconditions.checkArgument((data instanceof Short || data instanceof Byte ? 1 : 0) != 0);
            return ((Number)data).shortValue();
        }

        @Override
        public Class<?> javaClass() {
            return Short.class;
        }

        @Override
        public boolean isCollection() {
            return false;
        }

        @Override
        public boolean isIntegerType() {
            return true;
        }
    }
    ,
    INT{

        @Override
        public Object checkAndUpgrade(Object data) {
            Preconditions.checkArgument((data instanceof Integer || data instanceof Short || data instanceof Byte ? 1 : 0) != 0);
            return ((Number)data).intValue();
        }

        @Override
        public Class<?> javaClass() {
            return Integer.class;
        }

        @Override
        public boolean isCollection() {
            return false;
        }

        @Override
        public boolean isIntegerType() {
            return true;
        }
    }
    ,
    LONG{

        @Override
        public Object checkAndUpgrade(Object data) {
            Preconditions.checkArgument((data instanceof Long || data instanceof Integer || data instanceof Short || data instanceof Byte ? 1 : 0) != 0);
            return ((Number)data).longValue();
        }

        @Override
        public Class<?> javaClass() {
            return Long.class;
        }

        @Override
        public boolean isCollection() {
            return false;
        }

        @Override
        public boolean isIntegerType() {
            return true;
        }
    }
    ,
    FLOAT{

        @Override
        public Object checkAndUpgrade(Object data) {
            Preconditions.checkArgument((data instanceof Float || data instanceof Long || data instanceof Integer || data instanceof Short || data instanceof Byte ? 1 : 0) != 0);
            return Float.valueOf(((Number)data).floatValue());
        }

        @Override
        public Class<?> javaClass() {
            return Float.class;
        }

        @Override
        public boolean isCollection() {
            return false;
        }

        @Override
        public boolean isIntegerType() {
            return false;
        }
    }
    ,
    DOUBLE{

        @Override
        public Object checkAndUpgrade(Object data) {
            Preconditions.checkArgument((boolean)(data instanceof Number));
            return ((Number)data).doubleValue();
        }

        @Override
        public Class<?> javaClass() {
            return Double.class;
        }

        @Override
        public boolean isCollection() {
            return false;
        }

        @Override
        public boolean isIntegerType() {
            return false;
        }
    }
    ,
    STRING{

        @Override
        public Object checkAndUpgrade(Object data) {
            Preconditions.checkArgument((boolean)(data instanceof String));
            return data;
        }

        @Override
        public Class<?> javaClass() {
            return String.class;
        }

        @Override
        public boolean isCollection() {
            return false;
        }

        @Override
        public boolean isIntegerType() {
            return false;
        }
    }
    ,
    LIST{

        @Override
        public Object checkAndUpgrade(Object data) {
            Preconditions.checkArgument((boolean)(data instanceof List));
            return data;
        }

        @Override
        public Class<?> javaClass() {
            return List.class;
        }

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public boolean isIntegerType() {
            return false;
        }
    }
    ,
    MAP{

        @Override
        public Object checkAndUpgrade(Object data) {
            Preconditions.checkArgument((boolean)(data instanceof Map));
            return data;
        }

        @Override
        public Class<?> javaClass() {
            return Map.class;
        }

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public boolean isIntegerType() {
            return false;
        }
    }
    ,
    STRUCT{

        @Override
        public Object checkAndUpgrade(Object data) {
            Preconditions.checkArgument((boolean)(data instanceof Map));
            return data;
        }

        @Override
        public Class<?> javaClass() {
            return Map.class;
        }

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public boolean isIntegerType() {
            return false;
        }
    }
    ,
    UNION{

        @Override
        public Object checkAndUpgrade(Object data) {
            Preconditions.checkArgument((boolean)(data instanceof Map));
            return data;
        }

        @Override
        public Class<?> javaClass() {
            return Map.class;
        }

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public boolean isIntegerType() {
            return false;
        }
    };


    public abstract Class<?> javaClass();

    public abstract Object checkAndUpgrade(Object var1);

    public abstract boolean isIntegerType();

    public boolean isFloatingPoint() {
        return this == FLOAT || this == DOUBLE;
    }

    public boolean isMapLike() {
        return this == MAP || this == STRUCT;
    }

    public abstract boolean isCollection();

    public boolean isPrimitive() {
        return !this.isCollection();
    }

    public static HiveType fromHiveObjectInspector(ObjectInspector objectInspector) {
        TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)objectInspector);
        switch (typeInfo.getCategory()) {
            case PRIMITIVE: {
                PrimitiveObjectInspector primitiveInspector = (PrimitiveObjectInspector)objectInspector;
                return HiveType.fromHivePrimitiveCategory(primitiveInspector.getPrimitiveCategory());
            }
            case LIST: {
                return LIST;
            }
            case MAP: {
                return MAP;
            }
            case STRUCT: {
                return STRUCT;
            }
            case UNION: {
                return UNION;
            }
        }
        throw new IllegalArgumentException("Can't handle typeInfo " + typeInfo);
    }

    private static HiveType fromHivePrimitiveCategory(PrimitiveObjectInspector.PrimitiveCategory primitiveCategory) {
        switch (primitiveCategory) {
            case BOOLEAN: {
                return BOOLEAN;
            }
            case BYTE: {
                return BYTE;
            }
            case SHORT: {
                return SHORT;
            }
            case INT: {
                return INT;
            }
            case LONG: {
                return LONG;
            }
            case FLOAT: {
                return FLOAT;
            }
            case DOUBLE: {
                return DOUBLE;
            }
            case STRING: {
                return STRING;
            }
        }
        throw new IllegalArgumentException("Can't handle primitive category " + primitiveCategory);
    }
}

