/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hiveio.common;

import com.google.common.base.Objects;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;

public class HiveTableDesc
implements Writable {
    private static final String DEFAULT_DATABASE = "default";
    private String databaseName;
    private String tableName;

    public HiveTableDesc() {
        this.databaseName = DEFAULT_DATABASE;
        this.tableName = "_unknown_";
    }

    public HiveTableDesc(String tableName) {
        this.databaseName = DEFAULT_DATABASE;
        this.tableName = tableName;
    }

    public HiveTableDesc(String databaseName, String tableName) {
        this.databaseName = databaseName;
        this.tableName = tableName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String dotString() {
        return this.databaseName + "." + this.tableName;
    }

    public void readFields(DataInput in) throws IOException {
        this.databaseName = WritableUtils.readString((DataInput)in);
        this.tableName = WritableUtils.readString((DataInput)in);
    }

    public void write(DataOutput out) throws IOException {
        WritableUtils.writeString((DataOutput)out, (String)this.databaseName);
        WritableUtils.writeString((DataOutput)out, (String)this.tableName);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("databaseName", (Object)this.databaseName).add("tableName", (Object)this.tableName).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HiveTableDesc that = (HiveTableDesc)o;
        return Objects.equal((Object)this.databaseName, (Object)that.databaseName) && Objects.equal((Object)this.tableName, (Object)that.tableName);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.databaseName, this.tableName});
    }
}

