/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hiveio.common;

import com.barney4j.utils.unit.ByteUnit;
import com.google.common.base.Objects;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveStats {
    private static final Logger LOG = LoggerFactory.getLogger(HiveStats.class);
    private long totalSize;
    private long rawSize;
    private long numRows;

    public HiveStats() {
        this.totalSize = 0L;
        this.rawSize = 0L;
        this.numRows = 0L;
    }

    public HiveStats(long numRows, long rawSize, long totalSize) {
        this.numRows = numRows;
        this.rawSize = rawSize;
        this.totalSize = totalSize;
    }

    public long getNumRows() {
        return this.numRows;
    }

    public long getRawSizeInBytes() {
        return this.rawSize;
    }

    public double getRawSizeInMB() {
        return ByteUnit.BYTE.toMB(this.rawSize);
    }

    public long getTotalSizeInBytes() {
        return this.totalSize;
    }

    public double getTotalSizeInMB() {
        return ByteUnit.BYTE.toMB(this.totalSize);
    }

    public void add(HiveStats other) {
        this.totalSize += other.totalSize;
        this.rawSize += other.rawSize;
        this.numRows += other.numRows;
    }

    public static HiveStats fromParams(Map<String, String> params) {
        LOG.info("Table params: {}", params);
        long totalSize = Long.parseLong(params.get("totalSize"));
        long rawSize = Long.parseLong(params.get("rawDataSize"));
        long numRows = Long.parseLong(params.get("numRows"));
        return new HiveStats(numRows, rawSize, totalSize);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("totalSize", this.totalSize).add("rawSize", this.rawSize).add("numRows", this.numRows).toString();
    }
}

