/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hiveio.common;

import com.facebook.hiveio.common.HiveUtils;
import com.facebook.hiveio.conf.HiveHooks;
import com.facebook.hiveio.conf.IntConfOption;
import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.ThriftHiveMetastore;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveMetastores {
    public static final IntConfOption METASTORE_TIMEOUT_MS = new IntConfOption("hiveio.metastore.timeout.ms", (int)TimeUnit.SECONDS.toMillis(60L));
    private static final Logger LOG = LoggerFactory.getLogger(HiveMetastores.class);
    private static ThriftHiveMetastore.Iface TEST_CLIENT;

    private HiveMetastores() {
    }

    @VisibleForTesting
    public static ThriftHiveMetastore.Iface getTestClient() {
        return TEST_CLIENT;
    }

    @VisibleForTesting
    public static void setTestClient(ThriftHiveMetastore.Iface testClient) {
        TEST_CLIENT = testClient;
    }

    public static ThriftHiveMetastore.Iface create(String host, int port) throws TTransportException {
        if (TEST_CLIENT != null) {
            return TEST_CLIENT;
        }
        return HiveMetastores.create(host, port, METASTORE_TIMEOUT_MS.getDefaultValue());
    }

    public static ThriftHiveMetastore.Iface create(HiveConf hiveConf) throws TException {
        if (TEST_CLIENT != null) {
            return TEST_CLIENT;
        }
        ThriftHiveMetastore.Iface client = HiveMetastores.createFromURIs(hiveConf);
        if (client == null) {
            client = HiveMetastores.createfromReflection(hiveConf);
        }
        return client;
    }

    public static ThriftHiveMetastore.Iface create(String host, int port, int timeoutMillis) throws TTransportException {
        if (TEST_CLIENT != null) {
            return TEST_CLIENT;
        }
        TSocket transport = new TSocket(host, port, timeoutMillis);
        transport.open();
        TBinaryProtocol protocol = new TBinaryProtocol((TTransport)transport);
        return new ThriftHiveMetastore.Client((TProtocol)protocol);
    }

    private static ThriftHiveMetastore.Iface createfromReflection(HiveConf hiveConf) throws TException {
        ThriftHiveMetastore.Iface thriftIface;
        Field clientField;
        HiveMetaStoreClient hiveClient;
        try {
            hiveClient = new HiveMetaStoreClient(hiveConf);
        }
        catch (MetaException e) {
            throw new TException((Throwable)e);
        }
        try {
            clientField = hiveClient.getClass().getDeclaredField("client");
        }
        catch (NoSuchFieldException e) {
            throw new TException((Throwable)e);
        }
        clientField.setAccessible(true);
        try {
            thriftIface = (ThriftHiveMetastore.Iface)clientField.get(hiveClient);
        }
        catch (IllegalAccessException e) {
            throw new TException((Throwable)e);
        }
        return thriftIface;
    }

    private static ThriftHiveMetastore.Iface createFromURIs(HiveConf conf) {
        List<URI> uris = HiveUtils.getURIs(conf, HiveConf.ConfVars.METASTOREURIS);
        if (uris.isEmpty()) {
            HiveHooks.runDriverPreHooks(conf);
            uris = HiveUtils.getURIs(conf, HiveConf.ConfVars.METASTOREURIS);
            if (uris.isEmpty()) {
                LOG.error("No Hive Metastore URIs to connect to after running hooks");
                return null;
            }
        }
        Collections.shuffle(uris);
        for (URI uri : uris) {
            try {
                LOG.info("Connecting to metastore at " + uri.getHost() + ":" + uri.getPort());
                return HiveMetastores.create(uri.getHost(), uri.getPort());
            }
            catch (TTransportException e) {
                LOG.warn("Failed to connect to {}:{}", new Object[]{uri.getHost(), uri.getPort(), e});
            }
        }
        return null;
    }
}

