/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hiveio.common;

import java.io.IOException;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopUtils.class);
    private static final String OUTPUT_DIR_KEY = "mapred.output.dir";

    protected HadoopUtils() {
    }

    public static void setConfIfPossible(Object object, Configuration conf) {
        if (object instanceof Configurable) {
            ((Configurable)object).setConf(conf);
        }
    }

    public static void setJobConfIfPossible(Object object, JobConf jobConf) {
        if (object instanceof JobConfigurable) {
            ((JobConfigurable)object).configure(jobConf);
        }
    }

    public static void configureInputFormat(InputFormat inputFormat, Configuration conf) {
        JobConf jobConf = new JobConf(conf);
        HadoopUtils.setJobConfIfPossible(inputFormat, jobConf);
        if (inputFormat instanceof TextInputFormat) {
            ((TextInputFormat)inputFormat).configure(jobConf);
        }
    }

    public static Configuration getConfIfPossible(Object object) {
        if (object instanceof Configurable) {
            return ((Configurable)object).getConf();
        }
        return null;
    }

    public static String getOutputDir(Configuration conf) {
        return conf.get(OUTPUT_DIR_KEY);
    }

    public static Path getOutputPath(Configuration conf) {
        return new Path(HadoopUtils.getOutputDir(conf));
    }

    public static void setOutputDir(Configuration conf, String path) {
        conf.set(OUTPUT_DIR_KEY, path);
    }

    public static void deleteOutputDir(Configuration conf) throws IOException {
        Path outputPath = HadoopUtils.getOutputPath(conf);
        outputPath.getFileSystem(conf).delete(outputPath, true);
    }

    public static void setMapAttempts(Configuration conf, int numAttempts) {
        conf.setInt("mapred.map.max.attempts", numAttempts);
    }

    public static void setPool(Configuration conf, String pool) {
        conf.set("mapred.fairscheduler.pool", pool);
    }

    public static boolean needSuccessMarker(Configuration conf) {
        return conf.getBoolean("mapreduce.fileoutputcommitter.marksuccessfuljobs", false);
    }

    public static void setOutputKeyWritableClass(Configuration conf, Class<? extends Writable> writableClass) {
        conf.set("mapred.output.key.class", writableClass.getName());
    }

    public static void setOutputValueWritableClass(Configuration conf, Class<? extends Writable> writableClass) {
        conf.get("mapred.output.value.class", writableClass.getName());
    }

    public static void setWorkOutputDir(TaskAttemptContext context) throws IOException {
        Configuration conf = context.getConfiguration();
        String outputPath = HadoopUtils.getOutputDir(conf);
        if (outputPath != null) {
            FileOutputCommitter foc = new FileOutputCommitter(HadoopUtils.getOutputPath(conf), context);
            Path path = foc.getWorkPath();
            FileSystem fs = path.getFileSystem(conf);
            fs.mkdirs(path);
            conf.set("mapred.work.output.dir", path.toString());
            LOG.info("Setting mapred.work.output.dir to {}", (Object)path.toString());
        }
    }

    public static void setInputDir(Configuration conf, String path) {
        conf.set("mapred.input.dir", path);
    }
}

