/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hiveio.common;

import com.facebook.hiveio.common.NativeCodeHelper;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.io.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.util.NativeCodeLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopNative
extends NativeCodeHelper {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopNative.class);
    private static boolean LOADED = false;
    private static Throwable ERROR = null;

    private HadoopNative() {
    }

    public static synchronized void requireHadoopNative() {
        if (LOADED) {
            return;
        }
        if (ERROR != null) {
            throw new RuntimeException("failed to load Hadoop native library", ERROR);
        }
        try {
            HadoopNative.loadLibrary("hadoop");
            Field field = NativeCodeLoader.class.getDeclaredField("nativeCodeLoaded");
            field.setAccessible(true);
            field.set(null, true);
            field = CodecPool.class.getDeclaredField("COMPRESSOR_POOL");
            HadoopNative.setFinalStatic(field, new HackListMap());
            field = CodecPool.class.getDeclaredField("DECOMPRESSOR_POOL");
            HadoopNative.setFinalStatic(field, new HackListMap());
            List codecs = CompressionCodecFactory.getCodecClasses((Configuration)new Configuration());
            LOG.info("Compression Codecs: {}", (Object)codecs);
            LOADED = true;
        }
        catch (Throwable t) {
            ERROR = t;
            throw new RuntimeException("failed to load Hadoop native library", ERROR);
        }
    }

    private static void setFinalStatic(Field field, Object newValue) throws Exception {
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        field.set(null, newValue);
    }

    private static class HackListMap<K, V>
    extends AbstractMap<K, List<? extends V>> {
        private HackListMap() {
        }

        @Override
        public Set<Map.Entry<K, List<? extends V>>> entrySet() {
            return Collections.emptySet();
        }

        @Override
        public List<? extends V> put(K key, List<? extends V> value) {
            return null;
        }

        @Override
        public List<? extends V> get(Object key) {
            return Lists.newArrayList();
        }
    }
}

