/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hiveio.common;

import com.facebook.hiveio.conf.IntConfOption;
import com.facebook.hiveio.conf.LongConfOption;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BackoffRetryTask<T> {
    public static final IntConfOption NUM_TRIES = new IntConfOption("hive.io.numtries", 5);
    public static final LongConfOption INITIAL_RETRY_DELAY_MSEC = new LongConfOption("hive.io.initialretrydelaymsec", 10000L);
    private static final Logger LOG = LoggerFactory.getLogger(BackoffRetryTask.class);
    private final int numTries;
    private final long initialRetryDelayMsec;

    public BackoffRetryTask(Configuration configuration) {
        this.numTries = NUM_TRIES.get(configuration);
        this.initialRetryDelayMsec = INITIAL_RETRY_DELAY_MSEC.get(configuration);
    }

    public abstract T idempotentTask() throws TException;

    public T run() throws IOException {
        boolean tryAgain = true;
        long delayMsec = this.initialRetryDelayMsec;
        for (int triesLeft = this.numTries; tryAgain && triesLeft > 0; --triesLeft) {
            try {
                return this.idempotentTask();
            }
            catch (Exception e) {
                if (!BackoffRetryTask.retriableException(e)) {
                    LOG.info("Caught an unexpected exception: " + e.getClass(), (Throwable)e);
                    throw new IllegalStateException(e);
                }
                if (triesLeft == 1) {
                    throw new IOException("No more retries left " + e);
                }
                tryAgain = true;
                long randomDelayMsec = (long)(Math.random() * (double)delayMsec);
                LOG.info("Failed, but will retry in " + randomDelayMsec + " msec : " + e);
                try {
                    Thread.sleep(randomDelayMsec);
                }
                catch (InterruptedException interrupted) {
                    tryAgain = false;
                }
                delayMsec *= 2L;
                continue;
            }
        }
        throw new IllegalStateException("We should never get here");
    }

    private static boolean retriableException(Exception exception) {
        return exception instanceof TException || exception instanceof MetaException;
    }
}

