/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hiveio.bean;

import com.facebook.hiveio.bean.FieldCopier;
import com.facebook.hiveio.bean.RowToBean;
import com.facebook.hiveio.bean.UnsafeFieldCopier;
import com.facebook.hiveio.common.UnsafeHelper;
import com.facebook.hiveio.record.HiveReadableRecord;
import com.facebook.hiveio.schema.HiveTableSchema;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.List;
import sun.misc.Unsafe;

public class UnsafeRowToBean<X>
implements RowToBean<X> {
    private static final Unsafe UNSAFE = UnsafeHelper.getUnsafe();
    private final List<FieldCopier> fieldCopiers = Lists.newArrayList();

    public UnsafeRowToBean(Class<X> klass, HiveTableSchema schema) {
        for (Field field : klass.getDeclaredFields()) {
            String name = field.getName();
            field.setAccessible(true);
            UnsafeFieldCopier fieldCopier = UnsafeFieldCopier.fromType(field.getType());
            int hiveIndex = schema.positionOf(name);
            if (hiveIndex == -1) {
                throw new IllegalArgumentException("Table " + schema.getTableDesc() + " does not have column " + name);
            }
            fieldCopier.setFromHiveIndex(hiveIndex);
            fieldCopier.setToObjectOffset(UNSAFE.objectFieldOffset(field));
            this.fieldCopiers.add(fieldCopier);
        }
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("fieldCopiers", this.fieldCopiers).toString();
    }

    @Override
    public void writeRow(HiveReadableRecord record, X result) {
        for (FieldCopier fieldCopier : this.fieldCopiers) {
            fieldCopier.setValue(record, result);
        }
    }
}

