/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hiveio.bean;

import com.esotericsoftware.reflectasm.FieldAccess;
import com.facebook.hiveio.bean.FieldCopier;
import com.facebook.hiveio.bean.ReflectasmFieldCopier;
import com.facebook.hiveio.bean.RowToBean;
import com.facebook.hiveio.record.HiveReadableRecord;
import com.facebook.hiveio.schema.HiveTableSchema;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectasmRowToBean<X>
implements RowToBean<X> {
    private static final Logger LOG = LoggerFactory.getLogger(ReflectasmRowToBean.class);
    private final List<FieldCopier> fieldCopiers = Lists.newArrayList();
    private final FieldAccess fieldAccess;

    public ReflectasmRowToBean(Class<X> klass, HiveTableSchema tableSchema) {
        this.fieldAccess = FieldAccess.get(klass);
        for (Field field : klass.getDeclaredFields()) {
            field.setAccessible(true);
            String name = field.getName();
            ReflectasmFieldCopier fieldCopier = ReflectasmFieldCopier.fromType(field.getType());
            fieldCopier.setFieldAccess(this.fieldAccess);
            int hiveIndex = tableSchema.positionOf(name);
            if (hiveIndex == -1) {
                throw new IllegalArgumentException("Table " + tableSchema.getTableDesc() + " does not have column " + name);
            }
            fieldCopier.setFromHiveIndex(hiveIndex);
            fieldCopier.setToObjectIndex(this.fieldAccess.getIndex(name));
            this.fieldCopiers.add(fieldCopier);
        }
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("fieldCopiers", this.fieldCopiers).toString();
    }

    @Override
    public void writeRow(HiveReadableRecord record, X result) {
        for (FieldCopier fieldCopier : this.fieldCopiers) {
            fieldCopier.setValue(record, result);
        }
    }
}

