/*
 * Decompiled with CFR 0.152.
 */
package com.barney4j.utils.unit;

import com.barney4j.utils.unit.BitUnit;

public enum ByteUnit {
    BYTE{

        @Override
        public double toBytes(double d) {
            return d;
        }

        @Override
        public double convert(double d, ByteUnit u) {
            return u.toBytes(d);
        }
    }
    ,
    KIB{

        @Override
        public double toBytes(double d) {
            return 2.safeMulti(d, C_KIB);
        }

        @Override
        public double convert(double d, ByteUnit u) {
            return u.toKiB(d);
        }
    }
    ,
    MIB{

        @Override
        public double toBytes(double d) {
            return 3.safeMulti(d, C_MIB);
        }

        @Override
        public double convert(double d, ByteUnit u) {
            return u.toMiB(d);
        }
    }
    ,
    GIB{

        @Override
        public double toBytes(double d) {
            return 4.safeMulti(d, C_GIB);
        }

        @Override
        public double convert(double d, ByteUnit u) {
            return u.toGiB(d);
        }
    }
    ,
    TIB{

        @Override
        public double toBytes(double d) {
            return 5.safeMulti(d, C_TIB);
        }

        @Override
        public double convert(double d, ByteUnit u) {
            return u.toTiB(d);
        }
    }
    ,
    PIB{

        @Override
        public double toBytes(double d) {
            return 6.safeMulti(d, C_PIB);
        }

        @Override
        public double convert(double d, ByteUnit u) {
            return u.toPiB(d);
        }
    }
    ,
    KB{

        @Override
        public double toBytes(double d) {
            return 7.safeMulti(d, C_KB);
        }

        @Override
        public double convert(double d, ByteUnit u) {
            return u.toKB(d);
        }
    }
    ,
    MB{

        @Override
        public double toBytes(double d) {
            return 8.safeMulti(d, C_MB);
        }

        @Override
        public double convert(double d, ByteUnit u) {
            return u.toMB(d);
        }
    }
    ,
    GB{

        @Override
        public double toBytes(double d) {
            return 9.safeMulti(d, C_GB);
        }

        @Override
        public double convert(double d, ByteUnit u) {
            return u.toGB(d);
        }
    }
    ,
    TB{

        @Override
        public double toBytes(double d) {
            return 10.safeMulti(d, C_TB);
        }

        @Override
        public double convert(double d, ByteUnit u) {
            return u.toTB(d);
        }
    }
    ,
    PB{

        @Override
        public double toBytes(double d) {
            return 11.safeMulti(d, C_PB);
        }

        @Override
        public double convert(double d, ByteUnit u) {
            return u.toPB(d);
        }
    };

    static final double C_KIB;
    static final double C_MIB;
    static final double C_GIB;
    static final double C_TIB;
    static final double C_PIB;
    static final double C_KB;
    static final double C_MB;
    static final double C_GB;
    static final double C_TB;
    static final double C_PB;
    private static final double MAX = Double.MAX_VALUE;

    static final double safeMulti(double d, double multi) {
        double limit = Double.MAX_VALUE / multi;
        if (d > limit) {
            return Double.MAX_VALUE;
        }
        if (d < -limit) {
            return Double.MIN_VALUE;
        }
        return d * multi;
    }

    public abstract double toBytes(double var1);

    public final double toKiB(double d) {
        return this.toBytes(d) / C_KIB;
    }

    public final double toMiB(double d) {
        return this.toBytes(d) / C_MIB;
    }

    public final double toGiB(double d) {
        return this.toBytes(d) / C_GIB;
    }

    public final double toTiB(double d) {
        return this.toBytes(d) / C_TIB;
    }

    public final double toPiB(double d) {
        return this.toBytes(d) / C_PIB;
    }

    public final double toKB(double d) {
        return this.toBytes(d) / C_KB;
    }

    public final double toMB(double d) {
        return this.toBytes(d) / C_MB;
    }

    public final double toGB(double d) {
        return this.toBytes(d) / C_GB;
    }

    public final double toTB(double d) {
        return this.toBytes(d) / C_TB;
    }

    public final double toPB(double d) {
        return this.toBytes(d) / C_PB;
    }

    public abstract double convert(double var1, ByteUnit var3);

    public final double convert(double d, BitUnit u) {
        return this.convert(d, u, 8);
    }

    public final double convert(double d, BitUnit u, int wordSize) {
        double bytes = u.toBits(d) / (double)wordSize;
        return this.convert(bytes, BYTE);
    }

    public final double toBits(double d) {
        return BitUnit.BIT.convert(d, this);
    }

    public final double toBits(double d, int wordSize) {
        return BitUnit.BIT.convert(d, this, wordSize);
    }

    public final double toKibit(double d) {
        return BitUnit.KIBIT.convert(d, this);
    }

    public final double toMibit(double d) {
        return BitUnit.MIBIT.convert(d, this);
    }

    public final double toGibit(double d) {
        return BitUnit.GIBIT.convert(d, this);
    }

    public final double toTibit(double d) {
        return BitUnit.TIBIT.convert(d, this);
    }

    public final double toPibit(double d) {
        return BitUnit.PIBIT.convert(d, this);
    }

    public final double toKibit(double d, int wordSize) {
        return BitUnit.KIBIT.convert(d, this, wordSize);
    }

    public final double toMibit(double d, int wordSize) {
        return BitUnit.MIBIT.convert(d, this, wordSize);
    }

    public final double toGibit(double d, int wordSize) {
        return BitUnit.GIBIT.convert(d, this, wordSize);
    }

    public final double toTibit(double d, int wordSize) {
        return BitUnit.TIBIT.convert(d, this, wordSize);
    }

    public final double toPibit(double d, int wordSize) {
        return BitUnit.PIBIT.convert(d, this, wordSize);
    }

    public final double toKbit(double d) {
        return BitUnit.KBIT.convert(d, this);
    }

    public final double toMbit(double d) {
        return BitUnit.MBIT.convert(d, this);
    }

    public final double toGbit(double d) {
        return BitUnit.GBIT.convert(d, this);
    }

    public final double toTbit(double d) {
        return BitUnit.TBIT.convert(d, this);
    }

    public final double toPbit(double d) {
        return BitUnit.PBIT.convert(d, this);
    }

    public final double toKbit(double d, int wordSize) {
        return BitUnit.KBIT.convert(d, this, wordSize);
    }

    public final double toMbit(double d, int wordSize) {
        return BitUnit.MBIT.convert(d, this, wordSize);
    }

    public final double toGbit(double d, int wordSize) {
        return BitUnit.GBIT.convert(d, this, wordSize);
    }

    public final double toTbit(double d, int wordSize) {
        return BitUnit.TBIT.convert(d, this, wordSize);
    }

    public final double toPbit(double d, int wordSize) {
        return BitUnit.PBIT.convert(d, this, wordSize);
    }

    static {
        C_KIB = Math.pow(2.0, 10.0);
        C_MIB = Math.pow(2.0, 20.0);
        C_GIB = Math.pow(2.0, 30.0);
        C_TIB = Math.pow(2.0, 40.0);
        C_PIB = Math.pow(2.0, 50.0);
        C_KB = Math.pow(10.0, 3.0);
        C_MB = Math.pow(10.0, 6.0);
        C_GB = Math.pow(10.0, 9.0);
        C_TB = Math.pow(10.0, 12.0);
        C_PB = Math.pow(10.0, 15.0);
    }
}

