/*
 * Decompiled with CFR 0.152.
 */
package com.barney4j.utils.unit;

import com.barney4j.utils.unit.ByteUnit;

public enum BitUnit {
    BIT{

        @Override
        public double toBits(double d) {
            return d;
        }

        @Override
        public double convert(double d, BitUnit u) {
            return u.toBits(d);
        }
    }
    ,
    KIBIT{

        @Override
        public double toBits(double d) {
            return 2.safeMulti(d, C_KIBIT);
        }

        @Override
        public double convert(double d, BitUnit u) {
            return u.toKibit(d);
        }
    }
    ,
    MIBIT{

        @Override
        public double toBits(double d) {
            return 3.safeMulti(d, C_MIBIT);
        }

        @Override
        public double convert(double d, BitUnit u) {
            return u.toMibit(d);
        }
    }
    ,
    GIBIT{

        @Override
        public double toBits(double d) {
            return 4.safeMulti(d, C_GIBIT);
        }

        @Override
        public double convert(double d, BitUnit u) {
            return u.toGibit(d);
        }
    }
    ,
    TIBIT{

        @Override
        public double toBits(double d) {
            return 5.safeMulti(d, C_TIBIT);
        }

        @Override
        public double convert(double d, BitUnit u) {
            return u.toTibit(d);
        }
    }
    ,
    PIBIT{

        @Override
        public double toBits(double d) {
            return 6.safeMulti(d, C_PIBIT);
        }

        @Override
        public double convert(double d, BitUnit u) {
            return u.toPibit(d);
        }
    }
    ,
    KBIT{

        @Override
        public double toBits(double d) {
            return 7.safeMulti(d, C_KBIT);
        }

        @Override
        public double convert(double d, BitUnit u) {
            return u.toKbit(d);
        }
    }
    ,
    MBIT{

        @Override
        public double toBits(double d) {
            return 8.safeMulti(d, C_MBIT);
        }

        @Override
        public double convert(double d, BitUnit u) {
            return u.toMbit(d);
        }
    }
    ,
    GBIT{

        @Override
        public double toBits(double d) {
            return 9.safeMulti(d, C_GBIT);
        }

        @Override
        public double convert(double d, BitUnit u) {
            return u.toGbit(d);
        }
    }
    ,
    TBIT{

        @Override
        public double toBits(double d) {
            return 10.safeMulti(d, C_TBIT);
        }

        @Override
        public double convert(double d, BitUnit u) {
            return u.toTbit(d);
        }
    }
    ,
    PBIT{

        @Override
        public double toBits(double d) {
            return 11.safeMulti(d, C_PBIT);
        }

        @Override
        public double convert(double d, BitUnit u) {
            return u.toPbit(d);
        }
    };

    static final double C_KIBIT;
    static final double C_MIBIT;
    static final double C_GIBIT;
    static final double C_TIBIT;
    static final double C_PIBIT;
    static final double C_KBIT;
    static final double C_MBIT;
    static final double C_GBIT;
    static final double C_TBIT;
    static final double C_PBIT;
    private static final double MAX = Double.MAX_VALUE;

    static final double safeMulti(double d, double multi) {
        double limit = Double.MAX_VALUE / multi;
        if (d > limit) {
            return Double.MAX_VALUE;
        }
        if (d < -limit) {
            return Double.MIN_VALUE;
        }
        return d * multi;
    }

    public abstract double toBits(double var1);

    public final double toKibit(double d) {
        return this.toBits(d) / C_KIBIT;
    }

    public final double toMibit(double d) {
        return this.toBits(d) / C_MIBIT;
    }

    public final double toGibit(double d) {
        return this.toBits(d) / C_GIBIT;
    }

    public final double toTibit(double d) {
        return this.toBits(d) / C_TIBIT;
    }

    public final double toPibit(double d) {
        return this.toBits(d) / C_PIBIT;
    }

    public final double toKbit(double d) {
        return this.toBits(d) / C_KBIT;
    }

    public final double toMbit(double d) {
        return this.toBits(d) / C_MBIT;
    }

    public final double toGbit(double d) {
        return this.toBits(d) / C_GBIT;
    }

    public final double toTbit(double d) {
        return this.toBits(d) / C_TBIT;
    }

    public final double toPbit(double d) {
        return this.toBits(d) / C_PBIT;
    }

    public abstract double convert(double var1, BitUnit var3);

    public final double convert(double d, ByteUnit u) {
        return this.convert(d, u, 8);
    }

    public final double convert(double d, ByteUnit u, int wordSize) {
        double bits = BitUnit.safeMulti(u.toBytes(d), wordSize);
        return this.convert(bits, BIT);
    }

    public final double toBytes(double d) {
        return ByteUnit.BYTE.convert(d, this);
    }

    public final double toBytes(double d, int wordSize) {
        return ByteUnit.BYTE.convert(d, this, wordSize);
    }

    public final double toKiB(double d) {
        return ByteUnit.KIB.convert(d, this);
    }

    public final double toMiB(double d) {
        return ByteUnit.MIB.convert(d, this);
    }

    public final double toGiB(double d) {
        return ByteUnit.GIB.convert(d, this);
    }

    public final double toTiB(double d) {
        return ByteUnit.TIB.convert(d, this);
    }

    public final double toPiB(double d) {
        return ByteUnit.PIB.convert(d, this);
    }

    public final double toKiB(double d, int wordSize) {
        return ByteUnit.KIB.convert(d, this, wordSize);
    }

    public final double toMiB(double d, int wordSize) {
        return ByteUnit.MIB.convert(d, this, wordSize);
    }

    public final double toGiB(double d, int wordSize) {
        return ByteUnit.GIB.convert(d, this, wordSize);
    }

    public final double toTiB(double d, int wordSize) {
        return ByteUnit.TIB.convert(d, this, wordSize);
    }

    public final double toPiB(double d, int wordSize) {
        return ByteUnit.PIB.convert(d, this, wordSize);
    }

    public final double toKB(double d) {
        return ByteUnit.KB.convert(d, this);
    }

    public final double toMB(double d) {
        return ByteUnit.MB.convert(d, this);
    }

    public final double toGB(double d) {
        return ByteUnit.GB.convert(d, this);
    }

    public final double toTB(double d) {
        return ByteUnit.TB.convert(d, this);
    }

    public final double toPB(double d) {
        return ByteUnit.PB.convert(d, this);
    }

    public final double toKB(double d, int wordSize) {
        return ByteUnit.KB.convert(d, this, wordSize);
    }

    public final double toMB(double d, int wordSize) {
        return ByteUnit.MB.convert(d, this, wordSize);
    }

    public final double toGB(double d, int wordSize) {
        return ByteUnit.GB.convert(d, this, wordSize);
    }

    public final double toTB(double d, int wordSize) {
        return ByteUnit.TB.convert(d, this, wordSize);
    }

    public final double toPB(double d, int wordSize) {
        return ByteUnit.PB.convert(d, this, wordSize);
    }

    static {
        C_KIBIT = Math.pow(2.0, 10.0);
        C_MIBIT = Math.pow(2.0, 20.0);
        C_GIBIT = Math.pow(2.0, 30.0);
        C_TIBIT = Math.pow(2.0, 40.0);
        C_PIBIT = Math.pow(2.0, 50.0);
        C_KBIT = Math.pow(10.0, 3.0);
        C_MBIT = Math.pow(10.0, 6.0);
        C_GBIT = Math.pow(10.0, 9.0);
        C_TBIT = Math.pow(10.0, 12.0);
        C_PBIT = Math.pow(10.0, 15.0);
    }
}

