/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.nifty.client;

import com.google.common.base.Preconditions;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.MessageEvent;

public final class TimeoutHandler
implements ChannelUpstreamHandler,
ChannelDownstreamHandler {
    private static final String NAME = "_TIMEOUT_HANDLER";
    private volatile long lastMessageReceivedNanos = 0L;
    private volatile long lastMessageSentNanos = 0L;

    public static synchronized void addToPipeline(ChannelPipeline cp) {
        Preconditions.checkNotNull((Object)cp, (Object)"cp is null");
        if (cp.get(NAME) == null) {
            cp.addFirst(NAME, (ChannelHandler)new TimeoutHandler());
        }
    }

    public static TimeoutHandler findTimeoutHandler(ChannelPipeline cp) {
        return (TimeoutHandler)cp.get(NAME);
    }

    private TimeoutHandler() {
    }

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        if (e instanceof MessageEvent) {
            this.lastMessageReceivedNanos = System.nanoTime();
        }
        ctx.sendUpstream(e);
    }

    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        if (e instanceof MessageEvent) {
            this.lastMessageSentNanos = System.nanoTime();
        }
        ctx.sendDownstream(e);
    }

    public long getLastMessageReceivedNanos() {
        return this.lastMessageReceivedNanos;
    }

    public long getLastMessageSentNanos() {
        return this.lastMessageSentNanos;
    }
}

