/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.nifty.client;

import com.facebook.nifty.client.NiftyClientChannel;
import com.facebook.nifty.client.RequestChannel;
import com.facebook.nifty.core.TChannelBufferInputTransport;
import com.facebook.nifty.core.TChannelBufferOutputTransport;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.thrift.TException;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

@NotThreadSafe
public class TNiftyClientChannelTransport
extends TTransport {
    private final Class<? extends TServiceClient> clientClass;
    private final NiftyClientChannel channel;
    private final Map<String, Boolean> methodNameToOneWay;
    private final TChannelBufferOutputTransport requestBufferTransport;
    private final TChannelBufferInputTransport responseBufferTransport;
    private final BlockingQueue<ResponseListener> queuedResponses;

    public TNiftyClientChannelTransport(Class<? extends TServiceClient> clientClass, NiftyClientChannel channel) {
        this.clientClass = clientClass;
        this.channel = channel;
        this.methodNameToOneWay = Maps.newHashMap();
        this.requestBufferTransport = new TChannelBufferOutputTransport();
        this.responseBufferTransport = new TChannelBufferInputTransport(ChannelBuffers.buffer((int)0));
        this.queuedResponses = Queues.newLinkedBlockingQueue();
    }

    public boolean isOpen() {
        return this.channel.getNettyChannel().isOpen();
    }

    public void open() throws TTransportException {
        if (!this.isOpen()) {
            throw new IllegalStateException("TNiftyClientChannelTransport requires an already-opened channel");
        }
    }

    public void close() {
        this.channel.close();
    }

    public int read(byte[] buf, int off, int len) throws TTransportException {
        if (!this.responseBufferTransport.isReadable()) {
            try {
                ResponseListener listener = this.queuedResponses.take();
                ChannelBuffer response = (ChannelBuffer)listener.getResponse().get();
                Preconditions.checkState((boolean)response.readable(), (Object)"Received an empty response");
                this.responseBufferTransport.setInputBuffer(response);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new TTransportException((Throwable)e);
            }
            catch (ExecutionException e) {
                Throwables.propagateIfInstanceOf((Throwable)e, TTransportException.class);
                throw new TTransportException((Throwable)e);
            }
        }
        return this.responseBufferTransport.read(buf, off, len);
    }

    public void write(byte[] buf, int off, int len) throws TTransportException {
        this.requestBufferTransport.write(buf, off, len);
    }

    public void flush() throws TTransportException {
        try {
            boolean sendOneWay = this.inOneWayRequest();
            ResponseListener listener = new ResponseListener();
            this.channel.sendAsynchronousRequest(this.requestBufferTransport.getOutputBuffer().copy(), sendOneWay, listener);
            this.queuedResponses.add(listener);
            this.requestBufferTransport.resetOutputBuffer();
        }
        catch (TException e) {
            Throwables.propagateIfInstanceOf((Throwable)e, TTransportException.class);
            throw new TTransportException(0, "Failed to use reflection on Client class to determine whether method is oneway", (Throwable)e);
        }
    }

    private boolean inOneWayRequest() throws TException {
        boolean isOneWayMethod = false;
        TChannelBufferInputTransport requestReadTransport = new TChannelBufferInputTransport(this.requestBufferTransport.getOutputBuffer().duplicate());
        TProtocol protocol = this.channel.getProtocolFactory().getOutputProtocolFactory().getProtocol((TTransport)requestReadTransport);
        TMessage message = protocol.readMessageBegin();
        String methodName = message.name;
        isOneWayMethod = this.clientClassHasReceiveHelperMethod(methodName);
        return isOneWayMethod;
    }

    private boolean clientClassHasReceiveHelperMethod(String methodName) {
        boolean isOneWayMethod = false;
        if (!this.methodNameToOneWay.containsKey(methodName)) {
            try {
                this.clientClass.getMethod("recv_" + methodName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                isOneWayMethod = true;
            }
            this.methodNameToOneWay.put(methodName, isOneWayMethod);
        } else {
            isOneWayMethod = this.methodNameToOneWay.get(methodName);
        }
        return isOneWayMethod;
    }

    private static class ResponseListener
    implements RequestChannel.Listener {
        private final SettableFuture<ChannelBuffer> response = SettableFuture.create();

        private ResponseListener() {
        }

        @Override
        public void onRequestSent() {
        }

        @Override
        public void onResponseReceived(ChannelBuffer response) {
            this.response.set((Object)response);
        }

        @Override
        public void onChannelError(TException cause) {
            this.response.setException((Throwable)new TTransportException(0, (Throwable)cause));
        }

        public ListenableFuture<ChannelBuffer> getResponse() {
            return this.response;
        }
    }
}

