/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.nifty.client;

import com.facebook.nifty.client.TNiftyClientListener;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;

@NotThreadSafe
class TNiftyAsyncClientTransport
extends TTransport
implements ChannelUpstreamHandler,
ChannelDownstreamHandler {
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private static final int MAX_BUFFERS_IN_QUEUE = 3;
    private final Channel channel;
    private final Queue<ChannelBuffer> writeBuffers;
    private volatile TNiftyClientListener listener;

    public TNiftyAsyncClientTransport(Channel channel) {
        this.channel = channel;
        this.writeBuffers = new ConcurrentLinkedQueue<ChannelBuffer>();
    }

    public void setListener(TNiftyClientListener listener) {
        this.listener = listener;
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public void open() throws TTransportException {
    }

    public void close() {
        this.channel.close();
    }

    public int read(byte[] bytes, int offset, int length) throws TTransportException {
        throw new UnsupportedOperationException();
    }

    public void write(byte[] bytes, int offset, int length) throws TTransportException {
        this.getWriteBuffer().writeBytes(bytes, offset, length);
    }

    public void flush() throws TTransportException {
        if (!this.writeBuffers.isEmpty()) {
            final ChannelBuffer channelBuffer = this.writeBuffers.remove();
            this.channel.write((Object)channelBuffer).addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        channelBuffer.clear();
                        if (TNiftyAsyncClientTransport.this.writeBuffers.size() < 3) {
                            TNiftyAsyncClientTransport.this.writeBuffers.add(channelBuffer);
                        }
                    }
                }
            });
        }
    }

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        if (e instanceof MessageEvent) {
            this.messageReceived(ctx, (MessageEvent)e);
        } else if (e instanceof ChannelStateEvent) {
            ChannelStateEvent evt = (ChannelStateEvent)e;
            switch (evt.getState()) {
                case OPEN: {
                    if (!Boolean.FALSE.equals(evt.getValue())) break;
                    this.listener.onChannelClosedOrDisconnected(ctx.getChannel());
                    break;
                }
                case CONNECTED: {
                    if (evt.getValue() != null) break;
                    this.listener.onChannelClosedOrDisconnected(ctx.getChannel());
                    break;
                }
            }
        } else if (e instanceof ExceptionEvent) {
            this.listener.onExceptionEvent((ExceptionEvent)e);
        }
        ctx.sendUpstream(e);
    }

    private void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
        if (e.getMessage() instanceof ChannelBuffer && this.listener != null) {
            this.listener.onFrameRead(ctx.getChannel(), (ChannelBuffer)e.getMessage());
        }
    }

    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        ctx.sendDownstream(e);
    }

    public ChannelBuffer getWriteBuffer() {
        if (this.writeBuffers.isEmpty()) {
            this.writeBuffers.add(ChannelBuffers.dynamicBuffer((int)1024));
        }
        return this.writeBuffers.peek();
    }
}

