/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.nifty.client;

import com.facebook.nifty.client.AbstractClientConnector;
import com.facebook.nifty.client.FramedClientChannel;
import com.facebook.nifty.client.NettyClientConfig;
import com.facebook.nifty.client.TimeoutHandler;
import com.facebook.nifty.duplex.TDuplexProtocolFactory;
import com.google.common.net.HostAndPort;
import java.net.InetSocketAddress;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.frame.LengthFieldBasedFrameDecoder;
import org.jboss.netty.handler.codec.frame.LengthFieldPrepender;

public class FramedClientConnector
extends AbstractClientConnector<FramedClientChannel> {
    private static final int LENGTH_FIELD_OFFSET = 0;
    private static final int LENGTH_FIELD_LENGTH = 4;
    private static final int LENGTH_ADJUSTMENT = 0;
    private static final int INITIAL_BYTES_TO_STRIP = 4;

    public FramedClientConnector(InetSocketAddress address) {
        this(address, FramedClientConnector.defaultProtocolFactory());
    }

    public FramedClientConnector(HostAndPort address) {
        this(address, FramedClientConnector.defaultProtocolFactory());
    }

    public FramedClientConnector(InetSocketAddress address, TDuplexProtocolFactory protocolFactory) {
        super(address, protocolFactory);
    }

    public FramedClientConnector(HostAndPort address, TDuplexProtocolFactory protocolFactory) {
        super(FramedClientConnector.toSocketAddress(address), protocolFactory);
    }

    @Override
    public FramedClientChannel newThriftClientChannel(Channel nettyChannel, NettyClientConfig clientConfig) {
        FramedClientChannel channel = new FramedClientChannel(nettyChannel, clientConfig.getTimer(), this.getProtocolFactory());
        ChannelPipeline cp = nettyChannel.getPipeline();
        TimeoutHandler.addToPipeline(cp);
        cp.addLast("thriftHandler", (ChannelHandler)channel);
        return channel;
    }

    @Override
    public ChannelPipelineFactory newChannelPipelineFactory(final int maxFrameSize, NettyClientConfig clientConfig) {
        return new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline cp = Channels.pipeline();
                TimeoutHandler.addToPipeline(cp);
                cp.addLast("frameEncoder", (ChannelHandler)new LengthFieldPrepender(4));
                cp.addLast("frameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(maxFrameSize, 0, 4, 0, 4));
                return cp;
            }
        };
    }
}

