/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.rexster.kibble;

import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.TransactionalGraph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.rexster.RexsterResourceContext;
import com.tinkerpop.rexster.extension.AbstractRexsterExtension;
import com.tinkerpop.rexster.extension.ExtensionApi;
import com.tinkerpop.rexster.extension.ExtensionDefinition;
import com.tinkerpop.rexster.extension.ExtensionDescriptor;
import com.tinkerpop.rexster.extension.ExtensionMethod;
import com.tinkerpop.rexster.extension.ExtensionNaming;
import com.tinkerpop.rexster.extension.ExtensionPoint;
import com.tinkerpop.rexster.extension.ExtensionResponse;
import com.tinkerpop.rexster.extension.HttpMethod;
import com.tinkerpop.rexster.extension.RexsterContext;
import com.tinkerpop.rexster.util.ElementHelper;
import com.tinkerpop.rexster.util.RequestObjectHelper;
import java.util.HashMap;
import java.util.Iterator;
import javax.ws.rs.core.Response;
import org.apache.giraph.rexster.kibble.IteratorEdge;
import org.apache.giraph.rexster.kibble.IteratorVertex;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;

@ExtensionNaming(namespace="tp", name="giraph")
public class GiraphExtension
extends AbstractRexsterExtension {
    public static final String EXTENSION_NAMESPACE = "tp";
    public static final String EXTENSION_NAME = "giraph";
    public static final String TX_KEY = "tx";
    public static final String VLABEL_KEY = "vlabel";
    public static final String DELAY_KEY = "delay";
    public static final String RETRY_KEY = "retry";
    private static final int VERTEX = 0;
    private static final int EDGE = 1;
    private static final Logger logger = Logger.getLogger(GiraphExtension.class);
    private int backoffRetry = 0;
    private int backoffDelay = 0;
    private String vlabel = null;
    private String lastInVId = "";
    private Vertex lastInV = null;

    @ExtensionDefinition(extensionPoint=ExtensionPoint.GRAPH, method=HttpMethod.GET, path="vertices")
    @ExtensionDescriptor(description="get vertices.", api={@ExtensionApi(parameterName="rexster.offset.start", description="start offset."), @ExtensionApi(parameterName="rexster.offset.end", description="end offset.")})
    public ExtensionResponse getVertices(@RexsterContext RexsterResourceContext context, @RexsterContext Graph graph) {
        long start = RequestObjectHelper.getStartOffset((JSONObject)context.getRequestObject());
        long end = RequestObjectHelper.getEndOffset((JSONObject)context.getRequestObject());
        try {
            Iterable vertices = graph.getVertices();
            return ExtensionResponse.ok((Iterator)new IteratorVertex(vertices.iterator(), start, end));
        }
        catch (Exception mqe) {
            logger.error((Object)mqe);
            return ExtensionResponse.error((String)"Error retrieving vertices.", (JSONObject)this.generateErrorJson());
        }
    }

    @ExtensionDefinition(extensionPoint=ExtensionPoint.GRAPH, method=HttpMethod.GET, path="edges")
    @ExtensionDescriptor(description="get edges.", api={@ExtensionApi(parameterName="rexster.offset.start", description="start offset."), @ExtensionApi(parameterName="rexster.offset.end", description="end offset.")})
    public ExtensionResponse getEdges(@RexsterContext RexsterResourceContext context, @RexsterContext Graph graph) {
        long start = RequestObjectHelper.getStartOffset((JSONObject)context.getRequestObject());
        long end = RequestObjectHelper.getEndOffset((JSONObject)context.getRequestObject());
        try {
            Iterable edges = graph.getEdges();
            return ExtensionResponse.ok((Iterator)new IteratorEdge(edges.iterator(), start, end));
        }
        catch (Exception mqe) {
            logger.error((Object)mqe);
            return ExtensionResponse.error((String)"Error retrieving edges.", (JSONObject)this.generateErrorJson());
        }
    }

    @ExtensionDefinition(extensionPoint=ExtensionPoint.GRAPH, method=HttpMethod.DELETE, autoCommitTransaction=true)
    @ExtensionDescriptor(description="delete the graph content.")
    public ExtensionResponse delete(@RexsterContext RexsterResourceContext context, @RexsterContext Graph graph) {
        Iterable vertices = graph.getVertices();
        for (Vertex current : vertices) {
            graph.removeVertex(current);
        }
        HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>();
        resultMap.put("success", true);
        return ExtensionResponse.ok((JSONObject)new JSONObject(resultMap));
    }

    @ExtensionDefinition(extensionPoint=ExtensionPoint.GRAPH, method=HttpMethod.POST, path="vertices", autoCommitTransaction=false)
    @ExtensionDescriptor(description="add vertices to the graph.")
    public ExtensionResponse postVertices(@RexsterContext RexsterResourceContext context, @RexsterContext Graph graph) {
        ExtensionResponse response = this.handlePost(graph, context, 0);
        if (graph instanceof TransactionalGraph) {
            TransactionalGraph tgraph = (TransactionalGraph)graph;
            tgraph.commit();
        }
        return response;
    }

    @ExtensionDefinition(extensionPoint=ExtensionPoint.GRAPH, method=HttpMethod.POST, path="edges", autoCommitTransaction=false)
    @ExtensionDescriptor(description="add edges to the graph.")
    public ExtensionResponse postEdges(@RexsterContext RexsterResourceContext context, @RexsterContext Graph graph) {
        return this.handlePost(graph, context, 1);
    }

    public ExtensionResponse handlePost(Graph graph, RexsterResourceContext context, int type) {
        JSONObject tx = context.getRequestObject();
        if (tx == null) {
            ExtensionMethod extMethod = context.getExtensionMethod();
            return ExtensionResponse.error((String)"no transaction JSON posted", null, (int)Response.Status.BAD_REQUEST.getStatusCode(), null, (JSONObject)this.generateErrorJson(extMethod.getExtensionApiAsJson()));
        }
        try {
            this.vlabel = tx.getString(VLABEL_KEY);
            if (tx.has(DELAY_KEY)) {
                this.backoffDelay = tx.getInt(DELAY_KEY);
            }
            if (tx.has(RETRY_KEY)) {
                this.backoffRetry = tx.getInt(RETRY_KEY);
            }
            JSONArray array = tx.optJSONArray(TX_KEY);
            for (int i = 0; i < array.length(); ++i) {
                JSONObject element = array.optJSONObject(i);
                this.createElement(element, graph, type);
            }
            HashMap<String, Comparable<Boolean>> resultMap = new HashMap<String, Comparable<Boolean>>();
            resultMap.put("success", Boolean.valueOf(true));
            resultMap.put("txProcessed", Integer.valueOf(array.length()));
            return ExtensionResponse.ok((JSONObject)new JSONObject(resultMap));
        }
        catch (IllegalArgumentException iae) {
            logger.error((Object)iae);
            ExtensionMethod extMethod = context.getExtensionMethod();
            return ExtensionResponse.error((String)iae.getMessage(), null, (int)Response.Status.BAD_REQUEST.getStatusCode(), null, (JSONObject)this.generateErrorJson(extMethod.getExtensionApiAsJson()));
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            return ExtensionResponse.error((String)("Error executing transaction: " + ex.getMessage()), (JSONObject)this.generateErrorJson());
        }
    }

    private void createElement(JSONObject element, Graph graph, int type) throws Exception {
        switch (type) {
            case 0: {
                String id = element.optString(this.vlabel);
                Vertex vertex = this.getVertex(graph, id);
                if (vertex != null) {
                    throw new Exception("Vertex with id " + id + " already exists.");
                }
                vertex = graph.addVertex(null);
                vertex.setProperty(this.vlabel, (Object)id);
                this.accumulateAttributes((Element)vertex, element);
                break;
            }
            case 1: {
                String inV = this.getProperty(element, "_inV", null);
                String outV = this.getProperty(element, "_outV", null);
                String label = this.getProperty(element, "_label", "none");
                if (outV == null || inV == null || outV.isEmpty() || inV.isEmpty()) {
                    throw new IllegalArgumentException("an edge must specify a _inV and _outV");
                }
                this.addEdge(graph, element, outV, inV, label);
                break;
            }
            default: {
                throw new Exception("Element type unknown.");
            }
        }
    }

    private void addEdge(Graph graph, JSONObject element, String outV, String inV, String label) throws Exception {
        Exception prevException = new RuntimeException("Exception initialized when trying commit.");
        for (int retryCount = 0; retryCount <= this.backoffRetry; ++retryCount) {
            if (retryCount > 0) {
                try {
                    double delay = (double)this.backoffDelay * Math.pow(2.0, retryCount);
                    Thread.sleep((long)delay);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
            Vertex in = this.getInputVertex(graph, inV);
            Vertex out = this.getVertex(graph, outV);
            if (out == null || in == null) {
                throw new Exception("the _inV or _outV vertices could not be found.");
            }
            Edge edge = graph.addEdge(null, out, in, label);
            this.accumulateAttributes((Element)edge, element);
            if (graph instanceof TransactionalGraph) {
                TransactionalGraph tgraph = (TransactionalGraph)graph;
                try {
                    tgraph.commit();
                    return;
                }
                catch (Exception e) {
                    tgraph.rollback();
                    logger.warn((Object)("Exception thrown while saving edge: " + e.toString()));
                    logger.warn((Object)("retry: " + retryCount));
                    prevException = e;
                    continue;
                }
            }
            return;
        }
        throw new RuntimeException(prevException);
    }

    private void accumulateAttributes(Element element, JSONObject obj) throws Exception {
        Iterator keys = obj.keys();
        while (keys.hasNext()) {
            String key = keys.next().toString();
            if (key.startsWith("_")) continue;
            element.setProperty(key, ElementHelper.getTypedPropertyValue((Object)obj.getString(key)));
        }
    }

    private String getProperty(JSONObject element, String label, String defaultValue) {
        String value = null;
        Object tmp = element.opt(label);
        if (tmp != null) {
            value = tmp.toString();
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    private Vertex getInputVertex(Graph graph, String inV) {
        Vertex in = null;
        if (inV.equals(this.lastInVId)) {
            in = this.lastInV;
        } else {
            this.lastInVId = inV;
            this.lastInV = in = this.getVertex(graph, inV);
        }
        return in;
    }

    private Vertex getVertex(Graph graph, String v) {
        Iterable vertexes = graph.getVertices(this.vlabel, (Object)v);
        Iterator itvertex = vertexes.iterator();
        if (!itvertex.hasNext()) {
            return null;
        }
        Vertex vertex = (Vertex)itvertex.next();
        if (itvertex.hasNext()) {
            return null;
        }
        return vertex;
    }
}

