/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.service;

import com.facebook.nifty.codec.DefaultThriftFrameCodecFactory;
import com.facebook.nifty.codec.ThriftFrameCodecFactory;
import com.facebook.nifty.core.NettyServerConfig;
import com.facebook.nifty.core.NettyServerConfigBuilder;
import com.facebook.nifty.core.NettyServerTransport;
import com.facebook.nifty.core.NiftyNoOpSecurityFactory;
import com.facebook.nifty.core.NiftySecurityFactory;
import com.facebook.nifty.core.NiftyTimer;
import com.facebook.nifty.core.ShutdownUtil;
import com.facebook.nifty.core.ThriftServerDef;
import com.facebook.nifty.core.ThriftServerDefBuilder;
import com.facebook.nifty.duplex.TDuplexProtocolFactory;
import com.facebook.nifty.processor.NiftyProcessor;
import com.facebook.nifty.processor.NiftyProcessorFactory;
import com.facebook.swift.service.ThriftServerConfig;
import com.facebook.swift.service.ThriftServerTimer;
import com.facebook.swift.service.ThriftServerWorkerExecutor;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import java.io.Closeable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TTransport;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ServerChannelFactory;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.BossPool;
import org.jboss.netty.channel.socket.nio.NioServerBossPool;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioWorkerPool;
import org.jboss.netty.channel.socket.nio.WorkerPool;
import org.jboss.netty.util.ThreadNameDeterminer;
import org.jboss.netty.util.Timer;
import org.weakref.jmx.Managed;

public class ThriftServer
implements Closeable {
    public static final ImmutableMap<String, TDuplexProtocolFactory> DEFAULT_PROTOCOL_FACTORIES = ImmutableMap.of((Object)"binary", (Object)TDuplexProtocolFactory.fromSingleFactory((TProtocolFactory)new TBinaryProtocol.Factory()), (Object)"compact", (Object)TDuplexProtocolFactory.fromSingleFactory((TProtocolFactory)new TCompactProtocol.Factory()));
    public static final ImmutableMap<String, ThriftFrameCodecFactory> DEFAULT_FRAME_CODEC_FACTORIES = ImmutableMap.of((Object)"buffered", (Object)new DefaultThriftFrameCodecFactory(), (Object)"framed", (Object)new DefaultThriftFrameCodecFactory());
    public static final ImmutableMap<String, ExecutorService> DEFAULT_WORKER_EXECUTORS = ImmutableMap.of();
    public static final NiftySecurityFactoryHolder DEFAULT_SECURITY_FACTORY = new NiftySecurityFactoryHolder();
    private final NettyServerTransport transport;
    private final int configuredPort;
    private final DefaultChannelGroup allChannels = new DefaultChannelGroup();
    private final Executor workerExecutor;
    private final ExecutorService acceptorExecutor;
    private final ExecutorService ioExecutor;
    private final int acceptorThreads;
    private final int ioThreads;
    private final ServerChannelFactory serverChannelFactory;
    private State state = State.NOT_STARTED;

    public ThriftServer(NiftyProcessor processor) {
        this(processor, new ThriftServerConfig());
    }

    public ThriftServer(NiftyProcessor processor, ThriftServerConfig config) {
        this(processor, config, (Timer)new NiftyTimer("thrift"));
    }

    public ThriftServer(NiftyProcessor processor, ThriftServerConfig config, Timer timer) {
        this(processor, config, timer, (Map<String, ThriftFrameCodecFactory>)DEFAULT_FRAME_CODEC_FACTORIES, (Map<String, TDuplexProtocolFactory>)DEFAULT_PROTOCOL_FACTORIES, (Map<String, ExecutorService>)DEFAULT_WORKER_EXECUTORS, DEFAULT_SECURITY_FACTORY);
    }

    public ThriftServer(NiftyProcessor processor, ThriftServerConfig config, @ThriftServerTimer Timer timer, Map<String, ThriftFrameCodecFactory> availableFrameCodecFactories, Map<String, TDuplexProtocolFactory> availableProtocolFactories, Map<String, ExecutorService> availableWorkerExecutors, NiftySecurityFactory securityFactory) {
        this(processor, config, timer, availableFrameCodecFactories, availableProtocolFactories, availableWorkerExecutors, new NiftySecurityFactoryHolder(securityFactory));
    }

    @Inject
    public ThriftServer(final NiftyProcessor processor, ThriftServerConfig config, @ThriftServerTimer Timer timer, Map<String, ThriftFrameCodecFactory> availableFrameCodecFactories, Map<String, TDuplexProtocolFactory> availableProtocolFactories, @ThriftServerWorkerExecutor Map<String, ExecutorService> availableWorkerExecutors, NiftySecurityFactoryHolder securityFactoryHolder) {
        Preconditions.checkNotNull(availableFrameCodecFactories, (Object)"availableFrameCodecFactories cannot be null");
        Preconditions.checkNotNull(availableProtocolFactories, (Object)"availableProtocolFactories cannot be null");
        NiftyProcessorFactory processorFactory = new NiftyProcessorFactory(){

            public NiftyProcessor getProcessor(TTransport transport) {
                return processor;
            }
        };
        String transportName = config.getTransportName();
        String protocolName = config.getProtocolName();
        Preconditions.checkState((boolean)availableFrameCodecFactories.containsKey(transportName), (Object)("No available server transport named " + transportName));
        Preconditions.checkState((boolean)availableProtocolFactories.containsKey(protocolName), (Object)("No available server protocol named " + protocolName));
        this.configuredPort = config.getPort();
        this.workerExecutor = config.getOrBuildWorkerExecutor(availableWorkerExecutors);
        this.acceptorExecutor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("thrift-acceptor-%s").build());
        this.acceptorThreads = config.getAcceptorThreadCount();
        this.ioExecutor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("thrift-io-%s").build());
        this.ioThreads = config.getIoThreadCount();
        this.serverChannelFactory = new NioServerSocketChannelFactory((BossPool)new NioServerBossPool((Executor)this.acceptorExecutor, this.acceptorThreads, ThreadNameDeterminer.CURRENT), (WorkerPool)new NioWorkerPool((Executor)this.ioExecutor, this.ioThreads, ThreadNameDeterminer.CURRENT));
        ThriftServerDef thriftServerDef = ((ThriftServerDefBuilder)((ThriftServerDefBuilder)((ThriftServerDefBuilder)((ThriftServerDefBuilder)((ThriftServerDefBuilder)((ThriftServerDefBuilder)((ThriftServerDefBuilder)((ThriftServerDefBuilder)((ThriftServerDefBuilder)((ThriftServerDefBuilder)((ThriftServerDefBuilder)ThriftServerDef.newBuilder().name("thrift")).listen(this.configuredPort)).limitFrameSizeTo((int)config.getMaxFrameSize().toBytes())).clientIdleTimeout(config.getIdleConnectionTimeout())).withProcessorFactory(processorFactory)).limitConnectionsTo(config.getConnectionLimit())).thriftFrameCodecFactory(availableFrameCodecFactories.get(transportName))).protocol(availableProtocolFactories.get(protocolName))).withSecurityFactory(securityFactoryHolder.niftySecurityFactory)).using(this.workerExecutor)).taskTimeout(config.getTaskExpirationTimeout())).build();
        NettyServerConfigBuilder nettyServerConfigBuilder = NettyServerConfig.newBuilder();
        nettyServerConfigBuilder.getServerSocketChannelConfig().setBacklog(config.getAcceptBacklog());
        nettyServerConfigBuilder.setBossThreadCount(config.getAcceptorThreadCount());
        nettyServerConfigBuilder.setWorkerThreadCount(config.getIoThreadCount());
        nettyServerConfigBuilder.setTimer(timer);
        NettyServerConfig nettyServerConfig = nettyServerConfigBuilder.build();
        this.transport = new NettyServerTransport(thriftServerDef, nettyServerConfig, (ChannelGroup)this.allChannels);
    }

    public ThriftServer(NettyServerConfig nettyServerConfig, ThriftServerDef thriftServerDef) {
        this.configuredPort = thriftServerDef.getServerPort();
        this.workerExecutor = thriftServerDef.getExecutor();
        this.acceptorExecutor = nettyServerConfig.getBossExecutor();
        this.acceptorThreads = nettyServerConfig.getBossThreadCount();
        this.ioExecutor = nettyServerConfig.getWorkerExecutor();
        this.ioThreads = nettyServerConfig.getWorkerThreadCount();
        this.serverChannelFactory = new NioServerSocketChannelFactory((BossPool)new NioServerBossPool((Executor)this.acceptorExecutor, this.acceptorThreads, ThreadNameDeterminer.CURRENT), (WorkerPool)new NioWorkerPool((Executor)this.ioExecutor, this.ioThreads, ThreadNameDeterminer.CURRENT));
        this.transport = new NettyServerTransport(thriftServerDef, nettyServerConfig, (ChannelGroup)this.allChannels);
    }

    @Managed
    public Integer getPort() {
        if (this.configuredPort != 0) {
            return this.configuredPort;
        }
        return this.getBoundPort();
    }

    @Managed
    public int getWorkerThreads() {
        if (this.workerExecutor instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.workerExecutor).getPoolSize();
        }
        return 0;
    }

    public Executor getWorkerExecutor() {
        return this.workerExecutor;
    }

    private int getBoundPort() {
        SocketAddress socketAddress = this.transport.getServerChannel().getLocalAddress();
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            return inetSocketAddress.getPort();
        }
        return 0;
    }

    @Managed
    public int getAcceptorThreads() {
        return this.acceptorThreads;
    }

    @Managed
    public int getIoThreads() {
        return this.ioThreads;
    }

    public synchronized boolean isRunning() {
        return this.state == State.RUNNING;
    }

    @PostConstruct
    public synchronized ThriftServer start() {
        Preconditions.checkState((this.state != State.CLOSED ? 1 : 0) != 0, (Object)"Thrift server is closed");
        if (this.state == State.NOT_STARTED) {
            this.transport.start(this.serverChannelFactory);
            this.state = State.RUNNING;
        }
        return this;
    }

    @Override
    @PreDestroy
    public synchronized void close() {
        if (this.state == State.CLOSED) {
            return;
        }
        if (this.state == State.RUNNING) {
            try {
                this.transport.stop();
            }
            catch (Exception e) {
                Thread.currentThread().interrupt();
            }
        }
        try {
            if (this.workerExecutor instanceof ExecutorService) {
                ShutdownUtil.shutdownExecutor((ExecutorService)((ExecutorService)this.workerExecutor), (String)"workerExecutor");
            }
            ShutdownUtil.shutdownChannelFactory((ChannelFactory)this.serverChannelFactory, (ExecutorService)this.acceptorExecutor, (ExecutorService)this.ioExecutor, (ChannelGroup)this.allChannels);
        }
        catch (Exception e) {
            Thread.currentThread().interrupt();
        }
        this.state = State.CLOSED;
    }

    public static class NiftySecurityFactoryHolder {
        @Inject(optional=true)
        public NiftySecurityFactory niftySecurityFactory = new NiftyNoOpSecurityFactory();

        @Inject
        public NiftySecurityFactoryHolder() {
        }

        public NiftySecurityFactoryHolder(NiftySecurityFactory niftySecurityFactory) {
            this.niftySecurityFactory = niftySecurityFactory;
        }
    }

    private static enum State {
        NOT_STARTED,
        RUNNING,
        CLOSED;

    }
}

